/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.type;

import com.liferay.notification.constants.NotificationRecipientSettingConstants;
import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.exception.NotificationQueueEntrySubjectException;
import com.liferay.notification.exception.NotificationRecipientSettingNameException;
import com.liferay.notification.exception.NotificationTemplateAttachmentObjectFieldIdException;
import com.liferay.notification.exception.NotificationTemplateDescriptionException;
import com.liferay.notification.exception.NotificationTemplateEditorTypeException;
import com.liferay.notification.exception.NotificationTemplateNameException;
import com.liferay.notification.exception.NotificationTemplateObjectDefinitionIdException;
import com.liferay.notification.exception.NotificationTemplateSubjectException;
import com.liferay.notification.model.NotificationQueueEntry;
import com.liferay.notification.model.NotificationRecipient;
import com.liferay.notification.model.NotificationRecipientSetting;
import com.liferay.notification.model.NotificationTemplate;
import com.liferay.notification.service.NotificationQueueEntryLocalService;
import com.liferay.notification.service.NotificationRecipientLocalService;
import com.liferay.notification.service.NotificationRecipientSettingLocalService;
import com.liferay.notification.term.evaluator.NotificationTermEvaluatorTracker;
import com.liferay.notification.type.NotificationType;
import com.liferay.notification.type.util.NotificationTypeUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectDefinitionLocalServiceUtil;
import com.liferay.object.service.ObjectFieldLocalServiceUtil;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseNotificationType
implements NotificationType {
    @Reference
    protected NotificationQueueEntryLocalService notificationQueueEntryLocalService;
    @Reference
    protected NotificationRecipientLocalService notificationRecipientLocalService;
    @Reference
    protected NotificationRecipientSettingLocalService notificationRecipientSettingLocalService;
    @Reference
    protected NotificationTermEvaluatorTracker notificationTermEvaluatorTracker;
    @Reference
    protected Portal portal;
    @Reference
    protected RoleLocalService roleLocalService;
    protected Locale siteDefaultLocale;
    protected Locale userLocale;
    @Reference
    protected UserLocalService userLocalService;

    @Override
    public NotificationQueueEntry createNotificationQueueEntry(User user, String body, NotificationContext notificationContext, String subject) {
        NotificationQueueEntry notificationQueueEntry = this.notificationQueueEntryLocalService.createNotificationQueueEntry(0L);
        notificationQueueEntry.setCompanyId(user.getCompanyId());
        notificationQueueEntry.setUserId(user.getUserId());
        notificationQueueEntry.setUserName(user.getFullName());
        NotificationTemplate notificationTemplate = notificationContext.getNotificationTemplate();
        if (notificationTemplate == null) {
            notificationQueueEntry.setNotificationTemplateId(0L);
        } else {
            notificationQueueEntry.setNotificationTemplateId(notificationTemplate.getNotificationTemplateId());
        }
        notificationQueueEntry.setBody(body);
        notificationQueueEntry.setClassName(notificationContext.getClassName());
        notificationQueueEntry.setClassPK(notificationContext.getClassPK());
        notificationQueueEntry.setPriority(0.0);
        notificationQueueEntry.setSubject(subject);
        notificationQueueEntry.setType(this.getType());
        notificationQueueEntry.setStatus(2);
        return notificationQueueEntry;
    }

    @Override
    public List<NotificationRecipientSetting> createNotificationRecipientSettings(long notificationRecipientId, Object[] recipients, User user) {
        ArrayList<NotificationRecipientSetting> notificationRecipientSettings = new ArrayList<NotificationRecipientSetting>();
        for (Object recipient : recipients) {
            Map recipientMap = (Map)recipient;
            for (Map.Entry entry : recipientMap.entrySet()) {
                if (!Objects.equals(recipientMap.get(NotificationRecipientSettingConstants.getRecipientTypeName((String)entry.getKey())), "role")) {
                    this._addNotificationRecipientSetting((String)entry.getKey(), notificationRecipientId, notificationRecipientSettings, user, entry.getValue());
                    continue;
                }
                HashSet<String> roleNames = new HashSet<String>();
                for (Map<String, String> roleMap : this._toList(entry.getValue())) {
                    Role role;
                    String roleName = roleMap.get("roleName");
                    if (Validator.isNull((String)roleName) || roleNames.contains(roleName) || (role = this.roleLocalService.fetchRole(user.getCompanyId(), roleName)) == null || role.getType() != 6 && role.getType() != 3 && role.getType() != 1) continue;
                    roleNames.add(roleName);
                    this._addNotificationRecipientSetting((String)entry.getKey(), notificationRecipientId, notificationRecipientSettings, user, roleName);
                }
            }
        }
        return notificationRecipientSettings;
    }

    @Override
    public String getType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getTypeLanguageKey() {
        return this.getType();
    }

    @Override
    public void sendNotification(NotificationContext notificationContext) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sendNotification(NotificationQueueEntry notificationQueueEntry) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toRecipients(List<NotificationRecipientSetting> notificationRecipientSettings) {
        return TransformUtil.transformToArray(notificationRecipientSettings, notificationRecipientSetting -> HashMapBuilder.put((Object)notificationRecipientSetting.getName(), (Object)notificationRecipientSetting.getValue()).build(), Object.class);
    }

    @Override
    public void validateNotificationQueueEntry(NotificationContext notificationContext) throws PortalException {
        NotificationQueueEntry notificationQueueEntry = notificationContext.getNotificationQueueEntry();
        if (Validator.isNull((String)notificationQueueEntry.getSubject())) {
            throw new NotificationQueueEntrySubjectException("Subject is null");
        }
    }

    @Override
    public void validateNotificationTemplate(NotificationContext notificationContext) throws PortalException {
        ObjectDefinition objectDefinition;
        NotificationTemplate notificationTemplate;
        Set<String> allowedNotificationRecipientSettingsNames = this.getAllowedNotificationRecipientSettingsNames();
        if (SetUtil.isNotEmpty(allowedNotificationRecipientSettingsNames)) {
            LinkedHashSet<String> notAllowedNotificationRecipientSettingsNames = new LinkedHashSet<String>();
            ListUtil.isNotEmptyForEach(notificationContext.getNotificationRecipientSettings(), notificationRecipientSetting -> {
                if (!allowedNotificationRecipientSettingsNames.contains(notificationRecipientSetting.getName())) {
                    notAllowedNotificationRecipientSettingsNames.add(notificationRecipientSetting.getName());
                }
            });
            if (!notAllowedNotificationRecipientSettingsNames.isEmpty()) {
                throw new NotificationRecipientSettingNameException.NotAllowedNames(notAllowedNotificationRecipientSettingsNames);
            }
        }
        if ((notificationTemplate = notificationContext.getNotificationTemplate()).getObjectDefinitionId() > 0L && (objectDefinition = ObjectDefinitionLocalServiceUtil.fetchObjectDefinition((long)notificationTemplate.getObjectDefinitionId())) == null) {
            throw new NotificationTemplateObjectDefinitionIdException();
        }
        String description = notificationTemplate.getDescription();
        if (description.length() > 255) {
            throw new NotificationTemplateDescriptionException("The description cannot contain more than 255 characters");
        }
        if (Validator.isNull((String)notificationTemplate.getEditorType())) {
            throw new NotificationTemplateEditorTypeException("Editor type is null");
        }
        if (Validator.isNull((String)notificationTemplate.getName())) {
            throw new NotificationTemplateNameException("Name is null");
        }
        if (Validator.isNull((String)notificationTemplate.getSubject())) {
            throw new NotificationTemplateSubjectException("Subject is null");
        }
        for (long attachmentObjectFieldId : notificationContext.getAttachmentObjectFieldIds()) {
            ObjectField objectField = ObjectFieldLocalServiceUtil.fetchObjectField((long)attachmentObjectFieldId);
            if (objectField != null && Objects.equals(objectField.getBusinessType(), "Attachment") && Objects.equals(objectField.getObjectDefinitionId(), notificationTemplate.getObjectDefinitionId())) continue;
            throw new NotificationTemplateAttachmentObjectFieldIdException();
        }
    }

    protected NotificationRecipient createNotificationRecipient(User user, long notificationQueueEntryId) {
        NotificationRecipient notificationRecipient = this.notificationRecipientLocalService.createNotificationRecipient(0L);
        notificationRecipient.setCompanyId(user.getCompanyId());
        notificationRecipient.setUserId(user.getUserId());
        notificationRecipient.setUserName(user.getFullName());
        notificationRecipient.setClassName(NotificationQueueEntry.class.getName());
        notificationRecipient.setClassPK(notificationQueueEntryId);
        return notificationRecipient;
    }

    protected List<NotificationRecipientSetting> createNotificationRecipientSettings(User user, long notificationRecipientId, Map<String, String> notificationRecipientSettingsMap) {
        ArrayList<NotificationRecipientSetting> notificationRecipientSettings = new ArrayList<NotificationRecipientSetting>();
        for (Map.Entry<String, String> entry : notificationRecipientSettingsMap.entrySet()) {
            NotificationRecipientSetting notificationRecipientSetting = this.notificationRecipientSettingLocalService.createNotificationRecipientSetting(0L);
            notificationRecipientSetting.setCompanyId(user.getCompanyId());
            notificationRecipientSetting.setUserId(user.getUserId());
            notificationRecipientSetting.setUserName(user.getFullName());
            notificationRecipientSetting.setNotificationRecipientId(notificationRecipientId);
            notificationRecipientSetting.setName(entry.getKey());
            notificationRecipientSetting.setValue(entry.getValue());
            notificationRecipientSettings.add(notificationRecipientSetting);
        }
        return notificationRecipientSettings;
    }

    protected String formatLocalizedContent(Map<Locale, String> contentMap, NotificationContext notificationContext) throws PortalException {
        String content = NotificationTypeUtil.evaluateTerms(contentMap.get(this.userLocale), notificationContext, this.notificationTermEvaluatorTracker);
        if (Validator.isNotNull((String)content)) {
            return content;
        }
        return NotificationTypeUtil.evaluateTerms(contentMap.get(this.siteDefaultLocale), notificationContext, this.notificationTermEvaluatorTracker);
    }

    protected void prepareNotificationContext(User user, String body, NotificationContext notificationContext, Object evaluatedNotificationRecipientSettings, String subject) {
        NotificationQueueEntry notificationQueueEntry = this.createNotificationQueueEntry(user, body, notificationContext, subject);
        notificationContext.setNotificationQueueEntry(notificationQueueEntry);
        NotificationRecipient notificationQueueEntryRecipient = this.createNotificationRecipient(user, notificationQueueEntry.getNotificationQueueEntryId());
        notificationContext.setNotificationRecipient(notificationQueueEntryRecipient);
        if (evaluatedNotificationRecipientSettings instanceof Map) {
            notificationContext.setNotificationRecipientSettings(this.createNotificationRecipientSettings(user, notificationQueueEntryRecipient.getNotificationRecipientId(), (Map)evaluatedNotificationRecipientSettings));
        } else {
            ArrayList<NotificationRecipientSetting> notificationRecipientSettings = new ArrayList<NotificationRecipientSetting>();
            for (Map evaluatedNotificationRecipientSetting : (List)evaluatedNotificationRecipientSettings) {
                notificationRecipientSettings.addAll(this.createNotificationRecipientSettings(user, notificationQueueEntryRecipient.getNotificationRecipientId(), evaluatedNotificationRecipientSetting));
            }
            notificationContext.setNotificationRecipientSettings(notificationRecipientSettings);
        }
    }

    private void _addNotificationRecipientSetting(String name, long notificationRecipientId, List<NotificationRecipientSetting> notificationRecipientSettings, User user, Object value) {
        NotificationRecipientSetting notificationRecipientSetting = this.notificationRecipientSettingLocalService.createNotificationRecipientSetting(0L);
        notificationRecipientSetting.setCompanyId(user.getCompanyId());
        notificationRecipientSetting.setUserId(user.getUserId());
        notificationRecipientSetting.setUserName(user.getFullName());
        notificationRecipientSetting.setNotificationRecipientId(notificationRecipientId);
        notificationRecipientSetting.setName(name);
        if (value instanceof LinkedHashMap) {
            notificationRecipientSetting.setValueMap(LocalizedMapUtil.getLocalizedMap((Map)((LinkedHashMap)value)));
        } else {
            notificationRecipientSetting.setValue(String.valueOf(value));
        }
        notificationRecipientSettings.add(notificationRecipientSetting);
    }

    private List<Map<String, String>> _toList(Object value) {
        if (value instanceof Object[]) {
            value = Arrays.asList((Object[])value);
        }
        return value;
    }
}

