/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.notification.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AttachedModel;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the NotificationQueueEntry service. Represents a row in the &quot;NotificationQueueEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.notification.model.impl.NotificationQueueEntryModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.notification.model.impl.NotificationQueueEntryImpl</code>.
 * </p>
 *
 * @author Gabriel Albuquerque
 * @see NotificationQueueEntry
 * @generated
 */
@ProviderType
public interface NotificationQueueEntryModel
	extends AttachedModel, AuditedModel, BaseModel<NotificationQueueEntry>,
			MVCCModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a notification queue entry model instance should use the {@link NotificationQueueEntry} interface instead.
	 */

	/**
	 * Returns the primary key of this notification queue entry.
	 *
	 * @return the primary key of this notification queue entry
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this notification queue entry.
	 *
	 * @param primaryKey the primary key of this notification queue entry
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this notification queue entry.
	 *
	 * @return the mvcc version of this notification queue entry
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this notification queue entry.
	 *
	 * @param mvccVersion the mvcc version of this notification queue entry
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the notification queue entry ID of this notification queue entry.
	 *
	 * @return the notification queue entry ID of this notification queue entry
	 */
	public long getNotificationQueueEntryId();

	/**
	 * Sets the notification queue entry ID of this notification queue entry.
	 *
	 * @param notificationQueueEntryId the notification queue entry ID of this notification queue entry
	 */
	public void setNotificationQueueEntryId(long notificationQueueEntryId);

	/**
	 * Returns the company ID of this notification queue entry.
	 *
	 * @return the company ID of this notification queue entry
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this notification queue entry.
	 *
	 * @param companyId the company ID of this notification queue entry
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this notification queue entry.
	 *
	 * @return the user ID of this notification queue entry
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this notification queue entry.
	 *
	 * @param userId the user ID of this notification queue entry
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this notification queue entry.
	 *
	 * @return the user uuid of this notification queue entry
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this notification queue entry.
	 *
	 * @param userUuid the user uuid of this notification queue entry
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this notification queue entry.
	 *
	 * @return the user name of this notification queue entry
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this notification queue entry.
	 *
	 * @param userName the user name of this notification queue entry
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this notification queue entry.
	 *
	 * @return the create date of this notification queue entry
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this notification queue entry.
	 *
	 * @param createDate the create date of this notification queue entry
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this notification queue entry.
	 *
	 * @return the modified date of this notification queue entry
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this notification queue entry.
	 *
	 * @param modifiedDate the modified date of this notification queue entry
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the notification template ID of this notification queue entry.
	 *
	 * @return the notification template ID of this notification queue entry
	 */
	public long getNotificationTemplateId();

	/**
	 * Sets the notification template ID of this notification queue entry.
	 *
	 * @param notificationTemplateId the notification template ID of this notification queue entry
	 */
	public void setNotificationTemplateId(long notificationTemplateId);

	/**
	 * Returns the body of this notification queue entry.
	 *
	 * @return the body of this notification queue entry
	 */
	@AutoEscape
	public String getBody();

	/**
	 * Sets the body of this notification queue entry.
	 *
	 * @param body the body of this notification queue entry
	 */
	public void setBody(String body);

	/**
	 * Returns the fully qualified class name of this notification queue entry.
	 *
	 * @return the fully qualified class name of this notification queue entry
	 */
	@Override
	public String getClassName();

	public void setClassName(String className);

	/**
	 * Returns the class name ID of this notification queue entry.
	 *
	 * @return the class name ID of this notification queue entry
	 */
	@Override
	public long getClassNameId();

	/**
	 * Sets the class name ID of this notification queue entry.
	 *
	 * @param classNameId the class name ID of this notification queue entry
	 */
	@Override
	public void setClassNameId(long classNameId);

	/**
	 * Returns the class pk of this notification queue entry.
	 *
	 * @return the class pk of this notification queue entry
	 */
	@Override
	public long getClassPK();

	/**
	 * Sets the class pk of this notification queue entry.
	 *
	 * @param classPK the class pk of this notification queue entry
	 */
	@Override
	public void setClassPK(long classPK);

	/**
	 * Returns the priority of this notification queue entry.
	 *
	 * @return the priority of this notification queue entry
	 */
	public double getPriority();

	/**
	 * Sets the priority of this notification queue entry.
	 *
	 * @param priority the priority of this notification queue entry
	 */
	public void setPriority(double priority);

	/**
	 * Returns the sent date of this notification queue entry.
	 *
	 * @return the sent date of this notification queue entry
	 */
	public Date getSentDate();

	/**
	 * Sets the sent date of this notification queue entry.
	 *
	 * @param sentDate the sent date of this notification queue entry
	 */
	public void setSentDate(Date sentDate);

	/**
	 * Returns the subject of this notification queue entry.
	 *
	 * @return the subject of this notification queue entry
	 */
	@AutoEscape
	public String getSubject();

	/**
	 * Sets the subject of this notification queue entry.
	 *
	 * @param subject the subject of this notification queue entry
	 */
	public void setSubject(String subject);

	/**
	 * Returns the type of this notification queue entry.
	 *
	 * @return the type of this notification queue entry
	 */
	@AutoEscape
	public String getType();

	/**
	 * Sets the type of this notification queue entry.
	 *
	 * @param type the type of this notification queue entry
	 */
	public void setType(String type);

	/**
	 * Returns the status of this notification queue entry.
	 *
	 * @return the status of this notification queue entry
	 */
	public int getStatus();

	/**
	 * Sets the status of this notification queue entry.
	 *
	 * @param status the status of this notification queue entry
	 */
	public void setStatus(int status);

	@Override
	public NotificationQueueEntry cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}