/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.multi.factor.authentication.ip.address.internal.checker;

import com.liferay.multi.factor.authentication.ip.address.internal.configuration.MFAIPAddressConfiguration;
import com.liferay.multi.factor.authentication.spi.checker.headless.HeadlessMFAChecker;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.audit.AuditException;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouterUtil;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.access.control.AccessControlUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapDictionary;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.multi.factor.authentication.ip.address.internal.configuration.MFAIPAddressConfiguration.scoped"}, service={})
public class IPAddressHeadlessMFAChecker
implements HeadlessMFAChecker {
    private static final Log _log = LogFactoryUtil.getLog(IPAddressHeadlessMFAChecker.class);
    private Set<String> _allowedIpAddressesAndNetmasks;
    private final MFAIPAddressAuditMessageBuilder _mfaipAddressAuditMessageBuilder = new MFAIPAddressAuditMessageBuilder();
    private ServiceRegistration<HeadlessMFAChecker> _serviceRegistration;
    @Reference
    private UserLocalService _userLocalService;

    public boolean verifyHeadlessRequest(HttpServletRequest httpServletRequest, long userId) {
        User user = this._userLocalService.fetchUser(userId);
        if (user == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Requested IP address verification for nonexistent user " + userId));
            }
            this._mfaipAddressAuditMessageBuilder.routeAuditMessage(this._mfaipAddressAuditMessageBuilder.buildNonexistentUserVerificationFailureAuditMessage(CompanyThreadLocal.getCompanyId(), userId, this._getClassName()));
            return false;
        }
        if (AccessControlUtil.isAccessAllowed((HttpServletRequest)httpServletRequest, this._allowedIpAddressesAndNetmasks)) {
            this._mfaipAddressAuditMessageBuilder.routeAuditMessage(this._mfaipAddressAuditMessageBuilder.buildVerificationSuccessAuditMessage(user, this._getClassName()));
            return true;
        }
        this._mfaipAddressAuditMessageBuilder.routeAuditMessage(this._mfaipAddressAuditMessageBuilder.buildVerificationFailureAuditMessage(user, this._getClassName(), "IP is not allowed"));
        return false;
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        MFAIPAddressConfiguration mfaIPAddressConfiguration = (MFAIPAddressConfiguration)ConfigurableUtil.createConfigurable(MFAIPAddressConfiguration.class, properties);
        if (!mfaIPAddressConfiguration.enabled()) {
            return;
        }
        this._allowedIpAddressesAndNetmasks = new HashSet<String>(Arrays.asList(mfaIPAddressConfiguration.allowedIPAddressAndNetMask()));
        this._serviceRegistration = bundleContext.registerService(HeadlessMFAChecker.class, (Object)this, (Dictionary)new HashMapDictionary(properties));
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration == null) {
            return;
        }
        this._serviceRegistration.unregister();
    }

    private String _getClassName() {
        Class<?> clazz = this.getClass();
        return clazz.getName();
    }

    private class MFAIPAddressAuditMessageBuilder {
        private final Log _log = LogFactoryUtil.getLog(MFAIPAddressAuditMessageBuilder.class);

        private MFAIPAddressAuditMessageBuilder() {
        }

        public AuditMessage buildNonexistentUserVerificationFailureAuditMessage(long companyId, long userId, String mfaCheckerClassName) {
            return new AuditMessage("MFA_IP_OTP_VERIFICATION_FAILURE", companyId, userId, "Nonexistent", mfaCheckerClassName, String.valueOf(userId), null, JSONUtil.put((String)"reason", (Object)"Nonexistent User"));
        }

        public AuditMessage buildVerificationFailureAuditMessage(User user, String mfaCheckerClassName, String reason) {
            return new AuditMessage("MFA_IP_OTP_VERIFICATION_FAILURE", user.getCompanyId(), user.getUserId(), user.getFullName(), mfaCheckerClassName, String.valueOf(user.getPrimaryKey()), null, JSONUtil.put((String)"reason", (Object)reason));
        }

        public AuditMessage buildVerificationSuccessAuditMessage(User user, String mfaCheckerClassName) {
            return new AuditMessage("MFA_IP_OTP_VERIFICATION_SUCCESS", user.getCompanyId(), user.getUserId(), user.getFullName(), mfaCheckerClassName, String.valueOf(user.getPrimaryKey()), null, null);
        }

        public void routeAuditMessage(AuditMessage auditMessage) {
            block4: {
                try {
                    AuditRouterUtil.route((AuditMessage)auditMessage);
                }
                catch (AuditException auditException) {
                    if (this._log.isWarnEnabled()) {
                        this._log.warn((Object)"Unable to route audit message", (Throwable)auditException);
                    }
                }
                catch (Exception exception) {
                    if (!this._log.isDebugEnabled()) break block4;
                    this._log.debug((Throwable)exception);
                }
            }
        }
    }
}

