/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.web.internal.rule.group.action;

import com.liferay.mobile.device.rules.action.ActionHandler;
import com.liferay.mobile.device.rules.model.MDRAction;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.service.ThemeLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ActionHandler.class})
public class ThemeModificationActionHandler
implements ActionHandler {
    private static final Collection<String> _propertyNames = Collections.unmodifiableCollection(Arrays.asList("colorSchemeId", "themeId"));
    @Reference
    private Portal _portal;
    @Reference
    private ThemeLocalService _themeLocalService;

    public static String getHandlerType() {
        return ThemeModificationActionHandler.class.getName();
    }

    public void applyAction(MDRAction mdrAction, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        UnicodeProperties typeSettingsProperties;
        String themeId;
        long companyId = this._portal.getCompanyId(httpServletRequest);
        Theme theme = this._themeLocalService.fetchTheme(companyId, themeId = GetterUtil.getString((String)(typeSettingsProperties = mdrAction.getTypeSettingsProperties()).getProperty("themeId")));
        if (theme == null) {
            theme = this._themeLocalService.getTheme(companyId, themeId);
        }
        if (theme == null) {
            return;
        }
        httpServletRequest.setAttribute("THEME", (Object)theme);
        String colorSchemeId = GetterUtil.getString((String)typeSettingsProperties.getProperty("colorSchemeId"));
        ColorScheme colorScheme = this._themeLocalService.fetchColorScheme(companyId, themeId, colorSchemeId);
        if (colorScheme == null) {
            colorScheme = this._themeLocalService.getColorScheme(companyId, themeId, colorSchemeId);
        }
        httpServletRequest.setAttribute("COLOR_SCHEME", (Object)colorScheme);
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        themeDisplay.setLookAndFeel(theme, colorScheme);
    }

    public String getEditorJSP() {
        return "/action/theme.jsp";
    }

    public Collection<String> getPropertyNames() {
        return _propertyNames;
    }

    public String getType() {
        return ThemeModificationActionHandler.getHandlerType();
    }

    public void setThemeLocalService(ThemeLocalService themeLocalService) {
        this._themeLocalService = themeLocalService;
    }
}

