/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.web.internal.rule.group.action;

import com.liferay.mobile.device.rules.action.ActionHandler;
import com.liferay.mobile.device.rules.model.MDRAction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseRedirectActionHandler
implements ActionHandler {
    private static final Log _log = LogFactoryUtil.getLog(BaseRedirectActionHandler.class);

    public void applyAction(MDRAction mdrAction, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        String url = this.getURL(mdrAction, httpServletRequest, httpServletResponse);
        if (Validator.isNull((String)url)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"URL is null");
            }
            return;
        }
        String requestURL = String.valueOf(httpServletRequest.getRequestURL());
        if (StringUtil.contains((String)requestURL, (String)url)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Skipping redirect. Current URL contains redirect URL.");
            }
            return;
        }
        try {
            httpServletResponse.sendRedirect(url);
        }
        catch (IOException ioe) {
            throw new PortalException("Unable to redirect to " + url, (Throwable)ioe);
        }
    }

    protected abstract String getURL(MDRAction var1, HttpServletRequest var2, HttpServletResponse var3) throws PortalException;
}

