/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.web.internal.portlet.action;

import com.liferay.mobile.device.rules.model.MDRRule;
import com.liferay.mobile.device.rules.model.MDRRuleGroup;
import com.liferay.mobile.device.rules.service.MDRRuleGroupService;
import com.liferay.mobile.device.rules.service.MDRRuleService;
import com.liferay.mobile.device.rules.web.internal.portlet.action.ActionUtil;
import com.liferay.portal.kernel.bean.BeanParamUtil;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.util.ParamUtil;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_mobile_device_rules_web_portlet_MDRPortlet", "mvc.command.name=/mobile_device_rules/edit_rule"}, service={MVCRenderCommand.class})
public class EditRuleMVCRenderCommand
implements MVCRenderCommand {
    private static final Log _log = LogFactoryUtil.getLog(EditRuleMVCRenderCommand.class);
    private MDRRuleGroupService _mdrRuleGroupService;
    private MDRRuleService _mdrRuleService;

    public String render(RenderRequest renderRequest, RenderResponse renderResponse) {
        try {
            long ruleId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"ruleId");
            MDRRule rule = this._mdrRuleService.fetchRule(ruleId);
            renderRequest.setAttribute("MOBILE_DEVICE_RULES_RULE", (Object)rule);
            String type = BeanPropertiesUtil.getString((Object)rule, (String)"type");
            renderRequest.setAttribute("MOBILE_DEVICE_RULES_RULE_TYPE", (Object)type);
            renderRequest.setAttribute("MOBILE_DEVICE_RULES_RULE_EDITOR_JSP", (Object)ActionUtil.getRuleEditorJSP(type));
            long ruleGroupId = BeanParamUtil.getLong((Object)rule, (PortletRequest)renderRequest, (String)"ruleGroupId");
            MDRRuleGroup ruleGroup = this._mdrRuleGroupService.getRuleGroup(ruleGroupId);
            renderRequest.setAttribute("MOBILE_DEVICE_RULES_RULE_GROUP", (Object)ruleGroup);
            return "/edit_rule.jsp";
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return "/error.jsp";
        }
    }

    @Reference(unbind="-")
    protected void setMDRRuleGroupService(MDRRuleGroupService mdrRuleGroupService) {
        this._mdrRuleGroupService = mdrRuleGroupService;
    }

    @Reference(unbind="-")
    protected void setMDRRuleService(MDRRuleService mdrRuleService) {
        this._mdrRuleService = mdrRuleService;
    }
}

