/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.web.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.mobile.device.rules.model.MDRRule;
import com.liferay.mobile.device.rules.model.MDRRuleGroup;
import com.liferay.mobile.device.rules.service.MDRRuleGroupLocalService;
import com.liferay.mobile.device.rules.service.MDRRuleLocalService;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class MDRRuleStagedModelDataHandler
extends BaseStagedModelDataHandler<MDRRule> {
    public static final String[] CLASS_NAMES = new String[]{MDRRule.class.getName()};
    private MDRRuleGroupLocalService _mdrRuleGroupLocalService;
    private MDRRuleLocalService _mdrRuleLocalService;

    public void deleteStagedModel(MDRRule rule) {
        this._mdrRuleLocalService.deleteRule(rule);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) {
        MDRRule rule = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (rule != null) {
            this.deleteStagedModel(rule);
        }
    }

    public MDRRule fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._mdrRuleLocalService.fetchMDRRuleByUuidAndGroupId(uuid, groupId);
    }

    public List<MDRRule> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._mdrRuleLocalService.getMDRRulesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(MDRRule rule) {
        return rule.getNameCurrentValue();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, MDRRule rule) throws Exception {
        MDRRuleGroup ruleGroup = this._mdrRuleGroupLocalService.getRuleGroup(rule.getRuleGroupId());
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)rule, (StagedModel)ruleGroup, (String)"parent");
        Element ruleElement = portletDataContext.getExportDataElement((ClassedModel)rule);
        portletDataContext.addClassedModel(ruleElement, ExportImportPathUtil.getModelPath((StagedModel)rule), (ClassedModel)rule);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, MDRRule rule) throws Exception {
        Map ruleGroupIds = portletDataContext.getNewPrimaryKeysMap(MDRRuleGroup.class);
        long ruleGroupId = MapUtil.getLong((Map)ruleGroupIds, (long)rule.getRuleGroupId(), (long)rule.getRuleGroupId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)rule);
        serviceContext.setUserId(portletDataContext.getUserId(rule.getUserUuid()));
        MDRRule importedRule = null;
        if (portletDataContext.isDataStrategyMirror()) {
            MDRRule existingRule = this.fetchStagedModelByUuidAndGroupId(rule.getUuid(), portletDataContext.getScopeGroupId());
            if (existingRule == null) {
                serviceContext.setUuid(rule.getUuid());
                importedRule = this._mdrRuleLocalService.addRule(ruleGroupId, rule.getNameMap(), rule.getDescriptionMap(), rule.getType(), rule.getTypeSettingsProperties(), serviceContext);
            } else {
                importedRule = this._mdrRuleLocalService.updateRule(existingRule.getRuleId(), rule.getNameMap(), rule.getDescriptionMap(), rule.getType(), rule.getTypeSettingsProperties(), serviceContext);
            }
        } else {
            importedRule = this._mdrRuleLocalService.addRule(ruleGroupId, rule.getNameMap(), rule.getDescriptionMap(), rule.getType(), rule.getTypeSettingsProperties(), serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)rule, (ClassedModel)importedRule);
    }

    @Reference(unbind="-")
    protected void setMDRRuleGroupLocalService(MDRRuleGroupLocalService mdrRuleGroupLocalService) {
        this._mdrRuleGroupLocalService = mdrRuleGroupLocalService;
    }

    @Reference(unbind="-")
    protected void setMDRRuleLocalService(MDRRuleLocalService mdrRuleLocalService) {
        this._mdrRuleLocalService = mdrRuleLocalService;
    }
}

