/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.web.internal.exportimport.data.handler;

import com.liferay.exportimport.kernel.lar.BasePortletDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.mobile.device.rules.model.MDRAction;
import com.liferay.mobile.device.rules.model.MDRRule;
import com.liferay.mobile.device.rules.model.MDRRuleGroup;
import com.liferay.mobile.device.rules.model.MDRRuleGroupInstance;
import com.liferay.mobile.device.rules.service.MDRActionLocalService;
import com.liferay.mobile.device.rules.service.MDRRuleGroupInstanceLocalService;
import com.liferay.mobile.device.rules.service.MDRRuleGroupLocalService;
import com.liferay.mobile.device.rules.service.MDRRuleLocalService;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.PropsValues;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_mobile_device_rules_web_portlet_MDRPortlet"}, service={PortletDataHandler.class})
public class MDRPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "mobile_device_rules";
    public static final String SCHEMA_VERSION = "1.0.0";
    private MDRActionLocalService _mdrActionLocalService;
    private MDRRuleGroupInstanceLocalService _mdrRuleGroupInstanceLocalService;
    private MDRRuleGroupLocalService _mdrRuleGroupLocalService;
    private MDRRuleLocalService _mdrRuleLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private Staging _staging;

    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    @Activate
    protected void activate() {
        this.setDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(MDRAction.class, Layout.class), new StagedModelType(MDRRule.class), new StagedModelType(MDRRuleGroup.class), new StagedModelType(MDRRuleGroupInstance.class, Layout.class)});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "rules", true, false, null, MDRRule.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "actions", true, false, null, MDRAction.class.getName(), Layout.class.getName())});
        this.setPublishToLiveByDefault(PropsValues.MOBILE_DEVICE_RULES_PUBLISH_TO_LIVE_BY_DEFAULT);
        this.setStagingControls(this.getExportControls());
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(MDRPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        this._mdrRuleGroupLocalService.deleteRuleGroups(portletDataContext.getGroupId());
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPortletPermissions("com.liferay.mobile.device.rules");
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        if (portletDataContext.getBooleanParameter(NAMESPACE, "rules")) {
            ExportActionableDynamicQuery rulesActionableDynamicQuery = this._mdrRuleLocalService.getExportActionableDynamicQuery(portletDataContext);
            rulesActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "actions")) {
            ExportActionableDynamicQuery actionsExportActionableDynamicQuery = this._mdrActionLocalService.getExportActionableDynamicQuery(portletDataContext);
            actionsExportActionableDynamicQuery.setStagedModelType(new StagedModelType(this._portal.getClassNameId(MDRAction.class), -1L));
            actionsExportActionableDynamicQuery.performActions();
        }
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPortletPermissions("com.liferay.mobile.device.rules");
        if (portletDataContext.getBooleanParameter(NAMESPACE, "rules")) {
            Element rulesElement = portletDataContext.getImportDataGroupElement(MDRRule.class);
            List ruleElements = rulesElement.elements();
            for (Element ruleElement : ruleElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)ruleElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "actions")) {
            Element actionsElement = portletDataContext.getImportDataGroupElement(MDRAction.class);
            List actionElements = actionsElement.elements();
            for (Element actionElement : actionElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)actionElement);
            }
        }
        return null;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        if (ExportImportDateUtil.isRangeFromLastPublishDate((PortletDataContext)portletDataContext)) {
            this._staging.populateLastPublishDateCounts(portletDataContext, new StagedModelType[]{new StagedModelType(MDRAction.class.getName(), Layout.class.getName()), new StagedModelType(MDRRule.class.getName()), new StagedModelType(MDRRuleGroup.class.getName()), new StagedModelType(MDRRuleGroupInstance.class.getName(), Layout.class.getName())});
            return;
        }
        ExportActionableDynamicQuery actionsExportActionableDynamicQuery = this._mdrActionLocalService.getExportActionableDynamicQuery(portletDataContext);
        actionsExportActionableDynamicQuery.setStagedModelType(new StagedModelType(MDRAction.class.getName(), Layout.class.getName()));
        actionsExportActionableDynamicQuery.performCount();
        ExportActionableDynamicQuery rulesActionableDynamicQuery = this._mdrRuleLocalService.getExportActionableDynamicQuery(portletDataContext);
        rulesActionableDynamicQuery.performCount();
        ExportActionableDynamicQuery ruleGroupsActionableDynamicQuery = this._mdrRuleGroupLocalService.getExportActionableDynamicQuery(portletDataContext);
        ruleGroupsActionableDynamicQuery.performCount();
        ExportActionableDynamicQuery ruleGroupInstancesExportActionableDynamicQuery = this._mdrRuleGroupInstanceLocalService.getExportActionableDynamicQuery(portletDataContext);
        ruleGroupInstancesExportActionableDynamicQuery.setStagedModelType(new StagedModelType(MDRRuleGroupInstance.class.getName(), Layout.class.getName()));
        ruleGroupInstancesExportActionableDynamicQuery.performCount();
    }

    @Reference(unbind="-")
    protected void setMDRActionLocalService(MDRActionLocalService mdrActionLocalService) {
        this._mdrActionLocalService = mdrActionLocalService;
    }

    @Reference(unbind="-")
    protected void setMDRRuleGroupInstanceLocalService(MDRRuleGroupInstanceLocalService mdrRuleGroupInstanceLocalService) {
        this._mdrRuleGroupInstanceLocalService = mdrRuleGroupInstanceLocalService;
    }

    @Reference(unbind="-")
    protected void setMDRRuleGroupLocalService(MDRRuleGroupLocalService mdrRuleGroupLocalService) {
        this._mdrRuleGroupLocalService = mdrRuleGroupLocalService;
    }

    @Reference(unbind="-")
    protected void setMDRRuleLocalService(MDRRuleLocalService mdrRuleLocalService) {
        this._mdrRuleLocalService = mdrRuleLocalService;
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }
}

