/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItemList;
import com.liferay.mobile.device.rules.model.MDRRuleGroup;
import com.liferay.mobile.device.rules.model.MDRRuleGroupInstance;
import com.liferay.mobile.device.rules.service.MDRActionLocalServiceUtil;
import com.liferay.mobile.device.rules.service.MDRRuleGroupInstanceLocalServiceUtil;
import com.liferay.mobile.device.rules.util.comparator.ActionCreateDateComparator;
import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class MDRActionDisplayContext {
    private String _displayStyle;
    private String _orderByCol;
    private String _orderByType;
    private PortletURL _portletURL;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private SearchContainer _ruleActionSearchContainer;
    private Long _ruleGroupInstanceId;

    public MDRActionDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse) {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
    }

    public List<NavigationItem> getActionNavigationItems() throws PortalException {
        final ThemeDisplay themeDisplay = (ThemeDisplay)this._renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        MDRRuleGroupInstance ruleGroupInstance = MDRRuleGroupInstanceLocalServiceUtil.getRuleGroupInstance((long)this.getRuleGroupInstanceId());
        final MDRRuleGroup ruleGroup = ruleGroupInstance.getRuleGroup();
        return new NavigationItemList(){
            {
                this.add(navigationItem -> {
                    navigationItem.setActive(true);
                    navigationItem.setHref((Object)"");
                    navigationItem.setLabel(LanguageUtil.format((Locale)themeDisplay.getLocale(), (String)"actions-for-x", (Object)ruleGroup.getName(themeDisplay.getLocale()), (boolean)false));
                });
            }
        };
    }

    public SearchContainer getActionSearchContainer() {
        if (this._ruleActionSearchContainer != null) {
            return this._ruleActionSearchContainer;
        }
        long ruleGroupInstanceId = this.getRuleGroupInstanceId();
        SearchContainer ruleActionSearchContainer = new SearchContainer((PortletRequest)this._renderRequest, this.getPortletURL(), null, "no-actions-are-configured-for-this-device-family");
        ruleActionSearchContainer.setOrderByCol(this.getOrderByCol());
        String orderByType = this.getOrderByType();
        boolean orderByAsc = orderByType.equals("asc");
        ActionCreateDateComparator orderByComparator = new ActionCreateDateComparator(orderByAsc);
        ruleActionSearchContainer.setOrderByComparator((OrderByComparator)orderByComparator);
        ruleActionSearchContainer.setOrderByType(orderByType);
        ruleActionSearchContainer.setRowChecker((RowChecker)new EmptyOnClickRowChecker((PortletResponse)this._renderResponse));
        ruleActionSearchContainer.setTotal(MDRActionLocalServiceUtil.getActionsCount((long)ruleGroupInstanceId));
        ruleActionSearchContainer.setResults(MDRActionLocalServiceUtil.getActions((long)ruleGroupInstanceId, (int)ruleActionSearchContainer.getStart(), (int)ruleActionSearchContainer.getEnd(), (OrderByComparator)orderByComparator));
        this._ruleActionSearchContainer = ruleActionSearchContainer;
        return this._ruleActionSearchContainer;
    }

    public String getDisplayStyle() {
        if (this._displayStyle != null) {
            return this._displayStyle;
        }
        this._displayStyle = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"displayStyle", (String)"list");
        return this._displayStyle;
    }

    public String getOrderByCol() {
        if (this._orderByCol != null) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByCol", (String)"create-date");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (this._orderByType != null) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        if (this._portletURL != null) {
            return this._portletURL;
        }
        String redirect = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"redirect");
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/view_actions.jsp");
        portletURL.setParameter("redirect", redirect);
        portletURL.setParameter("ruleGroupInstanceId", String.valueOf(this.getRuleGroupInstanceId()));
        this._portletURL = portletURL;
        return this._portletURL;
    }

    public long getRuleGroupInstanceId() {
        if (this._ruleGroupInstanceId != null) {
            return this._ruleGroupInstanceId;
        }
        this._ruleGroupInstanceId = ParamUtil.getLong((PortletRequest)this._renderRequest, (String)"ruleGroupInstanceId");
        return this._ruleGroupInstanceId;
    }
}

