/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.web.internal.portlet.action;

import com.liferay.mobile.device.rules.exception.NoSuchActionException;
import com.liferay.mobile.device.rules.exception.NoSuchRuleGroupException;
import com.liferay.mobile.device.rules.rule.RuleGroupProcessorUtil;
import com.liferay.mobile.device.rules.rule.RuleHandler;
import com.liferay.mobile.device.rules.rule.UnknownRuleHandlerException;
import com.liferay.mobile.device.rules.service.MDRRuleService;
import com.liferay.mobile.device.rules.web.internal.portlet.action.ActionUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_mobile_device_rules_web_portlet_MDRPortlet", "mvc.command.name=/mobile_device_rules/edit_rule"}, service={MVCActionCommand.class})
public class EditRuleMVCActionCommand
extends BaseMVCActionCommand {
    private MDRRuleService _mdrRuleService;

    protected void deleteRule(ActionRequest request) throws Exception {
        long ruleId = ParamUtil.getLong((PortletRequest)request, (String)"ruleId");
        this._mdrRuleService.deleteRule(ruleId);
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateRule(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteRule(actionRequest);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchActionException || e instanceof NoSuchRuleGroupException || e instanceof PrincipalException || e instanceof UnknownRuleHandlerException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            }
            throw e;
        }
    }

    @Reference(unbind="-")
    protected void setMDRRuleService(MDRRuleService mdrRuleService) {
        this._mdrRuleService = mdrRuleService;
    }

    protected void updateRule(ActionRequest actionRequest) throws Exception {
        long ruleId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"ruleId");
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        String type = ParamUtil.getString((PortletRequest)actionRequest, (String)"type");
        RuleHandler ruleHandler = RuleGroupProcessorUtil.getRuleHandler((String)type);
        if (ruleHandler == null) {
            throw new UnknownRuleHandlerException(type);
        }
        UnicodeProperties typeSettingsProperties = ActionUtil.getTypeSettingsProperties(actionRequest, ruleHandler.getPropertyNames());
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        if (ruleId <= 0L) {
            long ruleGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"ruleGroupId");
            this._mdrRuleService.addRule(ruleGroupId, nameMap, descriptionMap, type, typeSettingsProperties, serviceContext);
        } else {
            this._mdrRuleService.updateRule(ruleId, nameMap, descriptionMap, type, typeSettingsProperties, serviceContext);
        }
    }
}

