/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.microblogs.web.internal.asset.model;

import com.liferay.asset.kernel.model.BaseJSPAssetRenderer;
import com.liferay.microblogs.model.MicroblogsEntry;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MicroblogsEntryAssetRenderer
extends BaseJSPAssetRenderer<MicroblogsEntry> {
    private final MicroblogsEntry _entry;
    private final ModelResourcePermission<MicroblogsEntry> _microblogsEntryModelResourcePermission;

    public MicroblogsEntryAssetRenderer(MicroblogsEntry entry, ModelResourcePermission<MicroblogsEntry> modelResourcePermission) {
        this._entry = entry;
        this._microblogsEntryModelResourcePermission = modelResourcePermission;
    }

    public MicroblogsEntry getAssetObject() {
        return this._entry;
    }

    public String getClassName() {
        return MicroblogsEntry.class.getName();
    }

    public long getClassPK() {
        return this._entry.getMicroblogsEntryId();
    }

    public long getGroupId() {
        try {
            Group group = GroupLocalServiceUtil.getCompanyGroup((long)this._entry.getCompanyId());
            return group.getGroupId();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public String getJspPath(HttpServletRequest httpServletRequest, String template) {
        if (template.equals("abstract") || template.equals("full_content")) {
            return "/microblogs/asset/" + template + ".jsp";
        }
        return null;
    }

    public String getSummary(PortletRequest portletRequest, PortletResponse portletResponse) {
        return this._entry.getContent();
    }

    public String getTitle(Locale locale) {
        return this._entry.getContent();
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        try {
            User user = UserLocalServiceUtil.getUser((long)this._entry.getUserId());
            long portletPlid = PortalUtil.getPlidFromPortletId((long)user.getGroupId(), (String)"com_liferay_microblogs_web_portlet_MicroblogsPortlet");
            LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)liferayPortletRequest, (String)"com_liferay_microblogs_web_portlet_MicroblogsPortlet", (long)portletPlid, (String)"RENDER_PHASE");
            portletURL.setParameter("mvcPath", "/microblogs/view.jsp");
            long microblogsEntryId = this._entry.getMicroblogsEntryId();
            if (this._entry.getParentMicroblogsEntryId() > 0L) {
                microblogsEntryId = this._entry.getParentMicroblogsEntryId();
            }
            portletURL.setParameter("parentMicroblogsEntryId", String.valueOf(microblogsEntryId));
            return portletURL.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public long getUserId() {
        return this._entry.getUserId();
    }

    public String getUserName() {
        return this._entry.getUserName();
    }

    public String getUuid() {
        return null;
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) {
        try {
            return this._microblogsEntryModelResourcePermission.contains(permissionChecker, (ClassedModel)this._entry, "VIEW");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String template) throws Exception {
        httpServletRequest.setAttribute("MICROBLOGS_ENTRY", (Object)this._entry);
        return super.include(httpServletRequest, httpServletResponse, template);
    }
}

