/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.microblogs.web.internal.notifications;

import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.microblogs.model.MicroblogsEntry;
import com.liferay.microblogs.service.MicroblogsEntryLocalService;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.notifications.BaseModelUserNotificationHandler;
import com.liferay.portal.kernel.notifications.UserNotificationHandler;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_microblogs_web_portlet_MicroblogsPortlet"}, service={UserNotificationHandler.class})
public class MicroblogsUserNotificationHandler
extends BaseModelUserNotificationHandler {
    private MicroblogsEntryLocalService _microblogsEntryLocalService;
    @Reference
    private Portal _portal;
    private UserLocalService _userLocalService;

    public MicroblogsUserNotificationHandler() {
        this.setPortletId("com_liferay_microblogs_web_portlet_MicroblogsPortlet");
    }

    protected String getBodyContent(JSONObject jsonObject) {
        return HtmlUtil.stripHtml((String)jsonObject.getString("entryTitle"));
    }

    protected String getTitle(JSONObject jsonObject, AssetRenderer<?> assetRenderer, ServiceContext serviceContext) {
        String title = "";
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((Locale)serviceContext.getLocale(), MicroblogsUserNotificationHandler.class);
        MicroblogsEntry microblogsEntry = this._microblogsEntryLocalService.fetchMicroblogsEntry(assetRenderer.getClassPK());
        String userFullName = HtmlUtil.escape((String)this._portal.getUserName(microblogsEntry.getUserId(), ""));
        int notificationType = jsonObject.getInt("notificationType");
        if (notificationType == 0) {
            title = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"x-commented-on-your-post", (Object[])new Object[]{userFullName});
        } else if (notificationType == 1) {
            long parentMicroblogsEntryUserId = microblogsEntry.fetchParentMicroblogsEntryUserId();
            User user = this._userLocalService.fetchUser(parentMicroblogsEntryUserId);
            if (user != null) {
                title = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"x-also-commented-on-x's-post", (Object[])new Object[]{userFullName, user.getFullName()});
            }
        } else if (notificationType == 2) {
            title = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"x-commented-on-a-post-you-are-tagged-in", (Object[])new Object[]{userFullName});
        } else if (notificationType == 3) {
            title = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"x-tagged-you-in-a-post", (Object[])new Object[]{userFullName});
        }
        return title;
    }

    @Reference(unbind="-")
    protected void setMicroblogsEntryLocalService(MicroblogsEntryLocalService microblogsEntryLocalService) {
        this._microblogsEntryLocalService = microblogsEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

