/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.microblogs.web.internal.social;

import com.liferay.microblogs.model.MicroblogsEntry;
import com.liferay.microblogs.service.MicroblogsEntryLocalService;
import com.liferay.microblogs.service.permission.MicroblogsEntryPermission;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.social.kernel.model.BaseSocialActivityInterpreter;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.model.SocialActivityInterpreter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_microblogs_web_portlet_MicroblogsPortlet"}, service={SocialActivityInterpreter.class})
public class MicroblogsActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{MicroblogsEntry.class.getName()};
    private MicroblogsEntryLocalService _microblogsEntryLocalService;
    private ResourceBundleLoader _resourceBundleLoader;

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected String getBody(SocialActivity activity, ServiceContext serviceContext) {
        return this.getUserName(activity.getUserId(), serviceContext);
    }

    protected String getLink(SocialActivity activity, ServiceContext serviceContext) {
        return "";
    }

    protected ResourceBundleLoader getResourceBundleLoader() {
        return this._resourceBundleLoader;
    }

    protected String getTitle(SocialActivity activity, ServiceContext serviceContext) throws Exception {
        StringBundler sb = new StringBundler(5);
        MicroblogsEntry microblogsEntry = this._microblogsEntryLocalService.getMicroblogsEntry(activity.getClassPK());
        String receiverUserName = this.getUserName(activity.getReceiverUserId(), serviceContext);
        if (activity.getReceiverUserId() > 0L) {
            if (microblogsEntry.getType() == 1) {
                sb.append("@");
                sb.append(receiverUserName);
                sb.append(": ");
            } else if (microblogsEntry.getType() == 2) {
                sb.append(serviceContext.translate("reposted-from", new Object[0]));
                sb.append(" ");
                sb.append(receiverUserName);
                sb.append(": ");
            }
        }
        sb.append(HtmlUtil.escape((String)microblogsEntry.getContent()));
        return sb.toString();
    }

    protected boolean hasPermissions(PermissionChecker permissionChecker, SocialActivity activity, String actionId, ServiceContext serviceContext) throws Exception {
        MicroblogsEntry microblogsEntry = this._microblogsEntryLocalService.getMicroblogsEntry(activity.getClassPK());
        return MicroblogsEntryPermission.contains((PermissionChecker)permissionChecker, (MicroblogsEntry)microblogsEntry, (String)"VIEW");
    }

    @Reference(unbind="-")
    protected void setMicroblogsEntryLocalService(MicroblogsEntryLocalService microblogsEntryLocalService) {
        this._microblogsEntryLocalService = microblogsEntryLocalService;
    }

    @Reference(target="(bundle.symbolic.name=com.liferay.microblogs.web)", unbind="-")
    protected void setResourceBundleLoader(ResourceBundleLoader resourceBundleLoader) {
        this._resourceBundleLoader = new AggregateResourceBundleLoader(new ResourceBundleLoader[]{resourceBundleLoader, ResourceBundleLoaderUtil.getPortalResourceBundleLoader()});
    }
}

