/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.microblogs.web.internal.portlet;

import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.microblogs.model.MicroblogsEntry;
import com.liferay.microblogs.service.MicroblogsEntryLocalService;
import com.liferay.microblogs.service.MicroblogsEntryService;
import com.liferay.microblogs.util.MicroblogsUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.add-default-resource=true", "com.liferay.portlet.css-class-wrapper=microblogs-portlet", "com.liferay.portlet.display-category=category.collaboration", "com.liferay.portlet.footer-portlet-javascript=/microblogs/js/main.js", "com.liferay.portlet.header-portlet-css=/microblogs/css/main.css", "com.liferay.portlet.icon=/microblogs/icons/microblogs.png", "javax.portlet.display-name=Microblogs", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.view-template=/microblogs/view.jsp", "javax.portlet.name=com_liferay_microblogs_web_portlet_MicroblogsPortlet", "javax.portlet.portlet-info.keywords=Microblogs", "javax.portlet.portlet-info.short-title=Microblogs", "javax.portlet.portlet-info.title=Microblogs", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator,guest,power-user,user", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class MicroblogsPortlet
extends MVCPortlet {
    protected AssetEntryLocalService assetEntryLocalService;
    protected MicroblogsEntryLocalService microblogsEntryLocalService;
    protected MicroblogsEntryService microblogsEntryService;

    public void deleteMicroblogsEntry(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long microblogsEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"microblogsEntryId");
        this.microblogsEntryService.deleteMicroblogsEntry(microblogsEntryId);
    }

    public void updateMicroblogsEntry(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long microblogsEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"microblogsEntryId");
        String content = ParamUtil.getString((PortletRequest)actionRequest, (String)"content");
        int type = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"type");
        long parentMicroblogsEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentMicroblogsEntryId");
        int socialRelationType = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"socialRelationType");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)MicroblogsEntry.class.getName(), (PortletRequest)actionRequest);
        String[] assetTagNames = this.getAssetTagNames(content);
        serviceContext.setAssetTagNames(assetTagNames);
        if (microblogsEntryId > 0L) {
            this.microblogsEntryService.updateMicroblogsEntry(microblogsEntryId, content, socialRelationType, serviceContext);
        } else {
            this.microblogsEntryService.addMicroblogsEntry(themeDisplay.getUserId(), content, type, parentMicroblogsEntryId, socialRelationType, serviceContext);
        }
    }

    public void updateMicroblogsEntryViewCount(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long microblogsEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"microblogsEntryId");
        MicroblogsEntry microblogsEntry = this.microblogsEntryLocalService.fetchMicroblogsEntry(microblogsEntryId);
        if (microblogsEntry == null) {
            return;
        }
        this.assetEntryLocalService.incrementViewCounter(0L, MicroblogsEntry.class.getName(), microblogsEntryId, 1);
    }

    protected String[] getAssetTagNames(String content) {
        ArrayList assetTagNames = new ArrayList();
        assetTagNames.addAll(MicroblogsUtil.getHashtags((String)content));
        assetTagNames.addAll(MicroblogsUtil.getScreenNames((String)content));
        return assetTagNames.toArray(new String[assetTagNames.size()]);
    }

    @Reference(unbind="-")
    protected void setAssetEntryLocalService(AssetEntryLocalService assetEntryLocalService) {
        this.assetEntryLocalService = assetEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setMicroblogsEntryLocalService(MicroblogsEntryLocalService microblogsEntryLocalService) {
        this.microblogsEntryLocalService = microblogsEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setMicroblogsEntryService(MicroblogsEntryService microblogsEntryService) {
        this.microblogsEntryService = microblogsEntryService;
    }

    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.microblogs.web)(release.schema.version=1.0.1))", unbind="-")
    protected void setRelease(Release release) {
    }
}

