Liferay.Loader.define("message-boards-web@2.0.8/message_boards/js/MBPortlet.es", ['exports', 'metal/src/metal', 'metal-events/src/events', 'frontend-js-web/liferay/PortletBase.es'], function (exports, _metal, _events, _PortletBase2) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _metal2 = _interopRequireDefault(_metal);

	var _PortletBase3 = _interopRequireDefault(_PortletBase2);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	var _get = function get(object, property, receiver) {
		if (object === null) object = Function.prototype;
		var desc = Object.getOwnPropertyDescriptor(object, property);

		if (desc === undefined) {
			var parent = Object.getPrototypeOf(object);

			if (parent === null) {
				return undefined;
			} else {
				return get(parent, property, receiver);
			}
		} else if ("value" in desc) {
			return desc.value;
		} else {
			var getter = desc.get;

			if (getter === undefined) {
				return undefined;
			}

			return getter.call(receiver);
		}
	};

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var MBPortlet = function (_PortletBase) {
		_inherits(MBPortlet, _PortletBase);

		function MBPortlet() {
			_classCallCheck(this, MBPortlet);

			return _possibleConstructorReturn(this, (MBPortlet.__proto__ || Object.getPrototypeOf(MBPortlet)).apply(this, arguments));
		}

		_createClass(MBPortlet, [{
			key: 'created',
			value: function created() {
				this.eventHandler_ = new _events.EventHandler();
			}
		}, {
			key: 'attached',
			value: function attached() {
				var _this2 = this;

				var publishButton = this.one('.button-holder button[type="submit"]');

				if (publishButton) {
					this.eventHandler_.add(publishButton.addEventListener('click', function (e) {
						_this2.publish_(e);
					}));
				}

				var saveButton = this.one('#saveButton');

				if (saveButton) {
					this.eventHandler_.add(saveButton.addEventListener('click', function (e) {
						_this2.saveDraft_(e);
					}));
				}

				var advancedReplyLink = this.one('.advanced-reply');

				if (advancedReplyLink) {
					this.eventHandler_.add(advancedReplyLink.addEventListener('click', function (e) {
						_this2.openAdvancedReply_(e);
					}));
				}
			}
		}, {
			key: 'detached',
			value: function detached() {
				_get(MBPortlet.prototype.__proto__ || Object.getPrototypeOf(MBPortlet.prototype), 'detached', this).call(this);
				this.eventHandler_.removeAllListeners();
			}
		}, {
			key: 'openAdvancedReply_',
			value: function openAdvancedReply_() {
				var inputNode = this.one('#body');
				inputNode.value = window[this.ns('replyMessageBody' + this.replyToMessageId)].getHTML();

				var form = this.one('[name="' + this.ns('advancedReplyFm' + this.replyToMessageId) + '"]');

				var advancedReplyInputNode = form.querySelector('[name="' + this.ns('body') + '"]');

				advancedReplyInputNode.value = inputNode.value;

				submitForm(form);
			}
		}, {
			key: 'publish_',
			value: function publish_() {
				this.one('#workflowAction').value = this.constants.ACTION_PUBLISH;
				this.save_();
			}
		}, {
			key: 'save_',
			value: function save_() {
				var tempImages = this.all('img[data-random-id]');

				if (tempImages.length > 0) {
					if (confirm(this.strings.confirmDiscardImages)) {
						tempImages.forEach(function (node) {
							node.parentElement.remove();
						});

						this.submitForm_();
					}
				} else {
					this.submitForm_();
				}
			}
		}, {
			key: 'updateMultipleMBMessageAttachments_',
			value: function updateMultipleMBMessageAttachments_() {
				var _this3 = this;

				var selectedFileNameContainer = this.one('#selectedFileNameContainer');

				if (selectedFileNameContainer) {
					var inputName = this.ns('selectUploadedFile');

					var input = [].slice.call(this.all('input[name=' + inputName + ']:checked'));

					var data = input.map(function (item, index) {
						var id = index;
						var namespace = _this3.namespace;
						var value = item.value;

						return '<input id="' + namespace + 'selectedFileName' + id + '" name="' + namespace + 'selectedFileName" type="hidden" value="' + value + '" />';
					}).join('');

					selectedFileNameContainer.innerHTML = data;
				}
			}
		}, {
			key: 'submitForm_',
			value: function submitForm_() {
				this.one('#' + this.constants.CMD).value = this.currentAction;

				this.updateMultipleMBMessageAttachments_();

				if (this.replyToMessageId) {
					this.one('#body').value = window[this.ns('replyMessageBody' + this.replyToMessageId)].getHTML();

					submitForm(document[this.ns('addQuickReplyFm' + this.replyToMessageId)]);
				} else {
					this.one('#body').value = window[this.ns('bodyEditor')].getHTML();

					submitForm(document[this.ns('fm')]);
				}
			}
		}, {
			key: 'saveDraft_',
			value: function saveDraft_() {
				this.one('#workflowAction').value = this.constants.ACTION_SAVE_DRAFT;
				this.save_();
			}
		}]);

		return MBPortlet;
	}(_PortletBase3.default);

	/**
  * MBPortlet State definition.
  * @ignore
  * @static
  * @type {!Object}
  */

	MBPortlet.STATE = {

		/**
   * Portlet's constants
   * @instance
   * @memberof MBPortlet
   * @type {!Object}
   */

		constants: {
			validator: _metal2.default.isObject
		},

		/**
   * The current action (CMD.ADD, CMD.UPDATE, ...)
   * for the message
   * @instance
   * @memberof MBPortlet
   * @type {String}
   */

		currentAction: {
			validator: _metal2.default.isString
		},

		/**
   * The id of the message that
   * you are replying to
   * @instance
   * @memberof MBPortlet
   * @type {String}
   */

		replyToMessageId: {
			validator: _metal2.default.isString
		},

		/**
   * Portlet's messages
   * @instance
   * @memberof WikiPortlet
   * @type {Object}
   */

		strings: {
			validator: _metal2.default.isObject,
			value: {
				confirmDiscardImages: Liferay.Language.get('uploads-are-in-progress-confirmation')
			}
		}
	};

	exports.default = MBPortlet;
});
//# sourceMappingURL=MBPortlet.es.js.map
