/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.upload.format.handlers;

import com.liferay.message.boards.web.internal.upload.format.MBMessageFormatUploadHandler;
import com.liferay.message.boards.web.internal.util.MBAttachmentFileEntryReference;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"format=bbcode"}, service={MBMessageFormatUploadHandler.class})
public class MBMessageBBCodeFormatUploadHandler
implements MBMessageFormatUploadHandler {
    private PortletFileRepository _portletFileRepository;

    @Override
    public String replaceImageReferences(String content, List<MBAttachmentFileEntryReference> mbAttachmentFileEntryReferences) {
        for (MBAttachmentFileEntryReference mbAttachmentFileEntryReference : mbAttachmentFileEntryReferences) {
            Matcher matcher = this._getTempImagePattern(mbAttachmentFileEntryReference.getTempMBAttachmentFileEntryId()).matcher(content);
            content = matcher.replaceAll(this._getMBAttachmentFileEntryBBCodeImgTag(mbAttachmentFileEntryReference.getMBAttachmentFileEntry()));
        }
        return content;
    }

    @Reference(unbind="-")
    protected void setPortletFileRepository(PortletFileRepository portletFileRepository) {
        this._portletFileRepository = portletFileRepository;
    }

    private String _getMBAttachmentFileEntryBBCodeImgTag(FileEntry mbAttachmentFileEntry) {
        String fileEntryURL = this._portletFileRepository.getPortletFileEntryURL(null, mbAttachmentFileEntry, "");
        return "[img]" + fileEntryURL + "[/img]";
    }

    private Pattern _getTempImagePattern(long tempFileId) {
        return Pattern.compile(StringBundler.concat((String[])new String[]{"\\[img[^\\]]*?", "data-image-id", "=\"", String.valueOf(tempFileId), "\"[^\\]]*\\][^\\[]+\\[/img\\]"}));
    }
}

