/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.social;

import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.social.kernel.model.BaseSocialActivityInterpreter;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.model.SocialActivityInterpreter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"javax.portlet.name=com_liferay_message_boards_web_portlet_MBPortlet"}, service={SocialActivityInterpreter.class})
public class MBThreadActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{MBThread.class.getName()};
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference(target="(model.class.name=com.liferay.message.boards.model.MBMessage)")
    private ModelResourcePermission<MBMessage> _messageModelResourcePermission;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(bundle.symbolic.name=com.liferay.message.boards.web)")
    private volatile ResourceBundleLoader _resourceBundleLoader;

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected String getBody(SocialActivity activity, ServiceContext serviceContext) throws Exception {
        MBMessage message = this.getMessage(activity);
        if (message.getCategoryId() <= 0L) {
            return "";
        }
        StringBundler sb = new StringBundler(4);
        sb.append(serviceContext.getPortalURL());
        sb.append(serviceContext.getPathMain());
        sb.append("/message_boards/find_category?mbCategoryId=");
        sb.append(message.getCategoryId());
        String categoryLink = sb.toString();
        categoryLink = this.addNoSuchEntryRedirect(categoryLink, MBCategory.class.getName(), message.getCategoryId(), serviceContext);
        return this.wrapLink(categoryLink, "go-to-category", serviceContext);
    }

    protected MBMessage getMessage(SocialActivity activity) throws Exception {
        MBThread thread = this._mbThreadLocalService.getThread(activity.getClassPK());
        return this._mbMessageLocalService.getMessage(thread.getRootMessageId());
    }

    protected String getPath(SocialActivity activity, ServiceContext serviceContext) throws Exception {
        MBThread thread = this._mbThreadLocalService.getThread(activity.getClassPK());
        return "/message_boards/find_message?messageId=" + thread.getRootMessageId();
    }

    protected ResourceBundleLoader getResourceBundleLoader() {
        return this._resourceBundleLoader;
    }

    protected Object[] getTitleArguments(String groupName, SocialActivity activity, String link, String title, ServiceContext serviceContext) {
        String userName = this.getUserName(activity.getUserId(), serviceContext);
        String receiverUserName = "";
        if (activity.getReceiverUserId() > 0L) {
            receiverUserName = this.getUserName(activity.getReceiverUserId(), serviceContext);
        }
        return new Object[]{groupName, userName, receiverUserName, this.wrapLink(link, title)};
    }

    protected String getTitlePattern(String groupName, SocialActivity activity) {
        int activityType = activity.getType();
        if (activityType == 10007) {
            if (Validator.isNull((String)groupName)) {
                return "activity-message-boards-thread-move-to-trash";
            }
            return "activity-message-boards-thread-move-to-trash-in";
        }
        if (activityType == 10008) {
            if (Validator.isNull((String)groupName)) {
                return "activity-message-boards-thread-restore-from-trash";
            }
            return "activity-message-boards-thread-restore-from-trash-in";
        }
        return null;
    }

    protected boolean hasPermissions(PermissionChecker permissionChecker, SocialActivity activity, String actionId, ServiceContext serviceContext) throws Exception {
        MBMessage message = this.getMessage(activity);
        return this._messageModelResourcePermission.contains(permissionChecker, message.getMessageId(), actionId);
    }
}

