/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.security.permission;

import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBCategoryLocalService;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.BasePermissionPropagator;
import com.liferay.portal.kernel.security.permission.PermissionPropagator;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.portlet.ActionRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_message_boards_web_portlet_MBPortlet", "javax.portlet.name=com_liferay_message_boards_web_portlet_MBAdminPortlet"}, service={PermissionPropagator.class})
public class MBPermissionPropagatorImpl
extends BasePermissionPropagator {
    private MBCategoryLocalService _mbCategoryLocalService;
    private MBMessageLocalService _mbMessageLocalService;

    public void propagateRolePermissions(ActionRequest actionRequest, String className, String primKey, long[] roleIds) throws PortalException {
        if (className.equals(MBCategory.class.getName())) {
            this.propagateCategoryRolePermissions(actionRequest, className, primKey, roleIds);
        } else if (className.equals(MBMessage.class.getName())) {
            long messageId = GetterUtil.getLong((String)primKey);
            MBMessage message = this._mbMessageLocalService.getMessage(messageId);
            if (message.isRoot()) {
                this.propagateThreadRolePermissions(actionRequest, className, messageId, message.getThreadId(), roleIds);
            }
        } else if (className.equals("com.liferay.message.boards")) {
            this.propagateMBRolePermissions(actionRequest, className, primKey, roleIds);
        }
    }

    protected void propagateCategoryRolePermissions(ActionRequest actionRequest, String className, long primaryKey, long categoryId, long[] roleIds) throws PortalException {
        for (long roleId : roleIds) {
            this.propagateRolePermissions(actionRequest, roleId, className, primaryKey, MBCategory.class.getName(), categoryId);
        }
    }

    protected void propagateCategoryRolePermissions(final ActionRequest actionRequest, final String className, String primKey, final long[] roleIds) throws PortalException {
        final long categoryId = GetterUtil.getLong((String)primKey);
        MBCategory category = this._mbCategoryLocalService.getCategory(categoryId);
        List categoriesAndThreads = this._mbCategoryLocalService.getCategoriesAndThreads(category.getGroupId(), categoryId);
        for (Object categoryOrThread : categoriesAndThreads) {
            if (categoryOrThread instanceof MBThread) {
                MBThread thread = (MBThread)categoryOrThread;
                List messages = this._mbMessageLocalService.getThreadMessages(thread.getThreadId(), -1);
                for (MBMessage message : messages) {
                    this.propagateMessageRolePermissions(actionRequest, className, categoryId, message.getMessageId(), roleIds);
                }
                continue;
            }
            category = (MBCategory)categoryOrThread;
            List categoryIds = new ArrayList<Long>();
            categoryIds.add(category.getCategoryId());
            categoryIds = this._mbCategoryLocalService.getSubcategoryIds(categoryIds, category.getGroupId(), category.getCategoryId());
            Iterator iterator = categoryIds.iterator();
            while (iterator.hasNext()) {
                final long addCategoryId = (Long)iterator.next();
                this.propagateCategoryRolePermissions(actionRequest, className, categoryId, addCategoryId, roleIds);
                ActionableDynamicQuery actionableDynamicQuery = this._mbMessageLocalService.getActionableDynamicQuery();
                actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

                    public void addCriteria(DynamicQuery dynamicQuery) {
                        Property categoryIdProperty = PropertyFactoryUtil.forName((String)"categoryId");
                        dynamicQuery.add(categoryIdProperty.eq((Object)addCategoryId));
                    }
                });
                actionableDynamicQuery.setGroupId(category.getGroupId());
                actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<MBMessage>(){

                    public void performAction(MBMessage message) throws PortalException {
                        MBPermissionPropagatorImpl.this.propagateMessageRolePermissions(actionRequest, className, categoryId, message.getMessageId(), roleIds);
                    }
                });
                actionableDynamicQuery.performActions();
            }
        }
    }

    protected void propagateMBRolePermissions(final ActionRequest actionRequest, final String className, String primKey, final long[] roleIds) throws PortalException {
        final long groupId = GetterUtil.getLong((String)primKey);
        List categories = this._mbCategoryLocalService.getCategories(groupId);
        for (MBCategory category : categories) {
            this.propagateCategoryRolePermissions(actionRequest, className, groupId, category.getCategoryId(), roleIds);
        }
        ActionableDynamicQuery actionableDynamicQuery = this._mbMessageLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setGroupId(groupId);
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<MBMessage>(){

            public void performAction(MBMessage message) throws PortalException {
                MBPermissionPropagatorImpl.this.propagateMessageRolePermissions(actionRequest, className, groupId, message.getMessageId(), roleIds);
            }
        });
        actionableDynamicQuery.performActions();
    }

    protected void propagateMessageRolePermissions(ActionRequest actionRequest, String className, long primaryKey, long messageId, long[] roleIds) throws PortalException {
        for (long roleId : roleIds) {
            this.propagateRolePermissions(actionRequest, roleId, className, primaryKey, MBMessage.class.getName(), messageId);
        }
    }

    protected void propagateThreadRolePermissions(ActionRequest actionRequest, String className, long messageId, long threadId, long[] roleIds) throws PortalException {
        List messages = this._mbMessageLocalService.getThreadMessages(threadId, -1);
        for (MBMessage message : messages) {
            this.propagateMessageRolePermissions(actionRequest, className, messageId, message.getMessageId(), roleIds);
        }
    }

    @Reference(unbind="-")
    protected void setMBCategoryLocalService(MBCategoryLocalService mbCategoryLocalService) {
        this._mbCategoryLocalService = mbCategoryLocalService;
    }

    @Reference(unbind="-")
    protected void setMBMessageLocalService(MBMessageLocalService mbMessageLocalService) {
        this._mbMessageLocalService = mbMessageLocalService;
    }
}

