/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.portlet.configuration.icon;

import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.web.internal.portlet.action.ActionUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.portlet.configuration.icon.BasePortletConfigurationIcon;
import com.liferay.portal.kernel.portlet.configuration.icon.PortletConfigurationIcon;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.trash.TrashHelper;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_message_boards_web_portlet_MBAdminPortlet", "path=/message_boards/view_category"}, service={PortletConfigurationIcon.class})
public class DeleteCategoryPortletConfigurationIcon
extends BasePortletConfigurationIcon {
    @Reference(target="(model.class.name=com.liferay.message.boards.model.MBCategory)")
    private ModelResourcePermission<MBCategory> _categoryModelResourcePermission;
    @Reference
    private Portal _portal;
    @Reference
    private TrashHelper _trashHelper;

    public String getMessage(PortletRequest portletRequest) {
        String key = "delete";
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (this.isTrashEnabled(themeDisplay.getScopeGroupId())) {
            key = "move-to-recycle-bin";
        }
        return LanguageUtil.get((ResourceBundle)this.getResourceBundle(this.getLocale(portletRequest)), (String)key);
    }

    public String getURL(PortletRequest portletRequest, PortletResponse portletResponse) {
        try {
            PortletURL deleteURL = this._portal.getControlPanelPortletURL(portletRequest, "com_liferay_message_boards_web_portlet_MBAdminPortlet", "ACTION_PHASE");
            deleteURL.setParameter("javax.portlet.action", "/message_boards/edit_category");
            String cmd = "delete";
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (this.isTrashEnabled(themeDisplay.getScopeGroupId())) {
                cmd = "move_to_trash";
            }
            deleteURL.setParameter("cmd", cmd);
            PortletURL parentCategoryURL = this._portal.getControlPanelPortletURL(portletRequest, "com_liferay_message_boards_web_portlet_MBAdminPortlet", "RENDER_PHASE");
            MBCategory category = ActionUtil.getCategory(portletRequest);
            long parentCategoryId = this.getCategoryId(category.getParentCategory());
            if (parentCategoryId == 0L) {
                parentCategoryURL.setParameter("mvcRenderCommandName", "/message_boards/view");
            } else {
                parentCategoryURL.setParameter("mvcRenderCommandName", "/message_boards/view_category");
                parentCategoryURL.setParameter("mbCategoryId", String.valueOf(parentCategoryId));
            }
            deleteURL.setParameter("redirect", parentCategoryURL.toString());
            deleteURL.setParameter("mbCategoryId", String.valueOf(category.getCategoryId()));
            return deleteURL.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public double getWeight() {
        return 100.0;
    }

    public boolean isShow(PortletRequest portletRequest) {
        try {
            MBCategory category = ActionUtil.getCategory(portletRequest);
            if (category == null) {
                return false;
            }
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (this._categoryModelResourcePermission.contains(themeDisplay.getPermissionChecker(), (ClassedModel)category, "DELETE")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected long getCategoryId(MBCategory category) {
        long categoryId = 0L;
        if (category != null) {
            categoryId = category.getCategoryId();
        }
        return categoryId;
    }

    protected boolean isTrashEnabled(long groupId) {
        try {
            if (this._trashHelper.isTrashEnabled(groupId)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

