/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.portlet.action;

import com.liferay.captcha.configuration.CaptchaConfiguration;
import com.liferay.captcha.util.CaptchaUtil;
import com.liferay.message.boards.exception.CategoryNameException;
import com.liferay.message.boards.exception.MailingListEmailAddressException;
import com.liferay.message.boards.exception.MailingListInServerNameException;
import com.liferay.message.boards.exception.MailingListInUserNameException;
import com.liferay.message.boards.exception.MailingListOutEmailAddressException;
import com.liferay.message.boards.exception.MailingListOutServerNameException;
import com.liferay.message.boards.exception.MailingListOutUserNameException;
import com.liferay.message.boards.exception.NoSuchCategoryException;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.service.MBCategoryService;
import com.liferay.portal.kernel.captcha.CaptchaConfigurationException;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.trash.service.TrashEntryService;
import java.util.ArrayList;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_message_boards_web_portlet_MBPortlet", "javax.portlet.name=com_liferay_message_boards_web_portlet_MBAdminPortlet", "mvc.command.name=/message_boards/edit_category"}, service={MVCActionCommand.class})
public class EditCategoryMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private ConfigurationProvider _configurationProvider;
    private MBCategoryService _mbCategoryService;
    private TrashEntryService _trashEntryService;

    protected void deleteCategories(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long[] deleteCategoryIds = null;
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"mbCategoryId");
        deleteCategoryIds = categoryId > 0L ? new long[]{categoryId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteCategoryIds"), (long)0L);
        ArrayList<MBCategory> trashedModels = new ArrayList<MBCategory>();
        for (long deleteCategoryId : deleteCategoryIds) {
            if (moveToTrash) {
                MBCategory category = this._mbCategoryService.moveCategoryToTrash(deleteCategoryId);
                trashedModels.add(category);
                continue;
            }
            this._mbCategoryService.deleteCategory(themeDisplay.getScopeGroupId(), deleteCategoryId);
        }
        if (moveToTrash && !trashedModels.isEmpty()) {
            HashMap<String, ArrayList<MBCategory>> data = new HashMap<String, ArrayList<MBCategory>>();
            data.put("trashedModels", trashedModels);
            this.addDeleteSuccessData((PortletRequest)actionRequest, data);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateCategory(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteCategories(actionRequest, false);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteCategories(actionRequest, true);
            } else if (cmd.equals("restore")) {
                this.restoreTrashEntries(actionRequest);
            } else if (cmd.equals("subscribe")) {
                this.subscribeCategory(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribeCategory(actionRequest);
            }
        }
        catch (NoSuchCategoryException | PrincipalException e) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            actionResponse.setRenderParameter("mvcPath", "/message_boards/error.jsp");
        }
        catch (CategoryNameException | MailingListEmailAddressException | MailingListInServerNameException | MailingListInUserNameException | MailingListOutEmailAddressException | MailingListOutServerNameException | MailingListOutUserNameException | CaptchaConfigurationException | CaptchaTextException e) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass());
        }
    }

    protected CaptchaConfiguration getCaptchaConfiguration() throws CaptchaConfigurationException {
        try {
            return (CaptchaConfiguration)this._configurationProvider.getSystemConfiguration(CaptchaConfiguration.class);
        }
        catch (Exception e) {
            throw new CaptchaConfigurationException((Throwable)e);
        }
    }

    protected void restoreTrashEntries(ActionRequest actionRequest) throws Exception {
        long[] restoreTrashEntryIds;
        for (long restoreTrashEntryId : restoreTrashEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"restoreTrashEntryIds"), (long)0L)) {
            this._trashEntryService.restoreEntry(restoreTrashEntryId);
        }
    }

    @Reference(unbind="-")
    protected void setMBCategoryService(MBCategoryService mbCategoryService) {
        this._mbCategoryService = mbCategoryService;
    }

    @Reference(unbind="-")
    protected void setTrashEntryService(TrashEntryService trashEntryService) {
        this._trashEntryService = trashEntryService;
    }

    protected void subscribeCategory(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"mbCategoryId");
        this._mbCategoryService.subscribeCategory(themeDisplay.getScopeGroupId(), categoryId);
    }

    protected void unsubscribeCategory(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"mbCategoryId");
        this._mbCategoryService.unsubscribeCategory(themeDisplay.getScopeGroupId(), categoryId);
    }

    protected void updateCategory(ActionRequest actionRequest) throws Exception {
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"mbCategoryId");
        long parentCategoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentCategoryId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        String displayStyle = ParamUtil.getString((PortletRequest)actionRequest, (String)"displayStyle");
        String emailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailAddress");
        String inProtocol = ParamUtil.getString((PortletRequest)actionRequest, (String)"inProtocol");
        String inServerName = ParamUtil.getString((PortletRequest)actionRequest, (String)"inServerName");
        int inServerPort = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"inServerPort");
        boolean inUseSSL = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"inUseSSL");
        String inUserName = ParamUtil.getString((PortletRequest)actionRequest, (String)"inUserName");
        String inPassword = ParamUtil.getString((PortletRequest)actionRequest, (String)"inPassword");
        int inReadInterval = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"inReadInterval");
        String outEmailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"outEmailAddress");
        boolean outCustom = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"outCustom");
        String outServerName = ParamUtil.getString((PortletRequest)actionRequest, (String)"outServerName");
        int outServerPort = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"outServerPort");
        boolean outUseSSL = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"outUseSSL");
        String outUserName = ParamUtil.getString((PortletRequest)actionRequest, (String)"outUserName");
        String outPassword = ParamUtil.getString((PortletRequest)actionRequest, (String)"outPassword");
        boolean allowAnonymous = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"allowAnonymous");
        boolean mailingListActive = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"mailingListActive");
        boolean mergeWithParentCategory = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"mergeWithParentCategory");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)MBCategory.class.getName(), (PortletRequest)actionRequest);
        CaptchaConfiguration captchaConfiguration = this.getCaptchaConfiguration();
        if (categoryId <= 0L) {
            if (captchaConfiguration.messageBoardsEditMessageCaptchaEnabled()) {
                CaptchaUtil.check((PortletRequest)actionRequest);
            }
            this._mbCategoryService.addCategory(parentCategoryId, name, description, displayStyle, emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, allowAnonymous, mailingListActive, serviceContext);
        } else {
            this._mbCategoryService.updateCategory(categoryId, parentCategoryId, name, description, displayStyle, emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, allowAnonymous, mailingListActive, mergeWithParentCategory, serviceContext);
        }
    }
}

