/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.portlet.action;

import com.liferay.message.boards.exception.LockedThreadException;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBThreadService;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_message_boards_web_portlet_MBPortlet", "javax.portlet.name=com_liferay_message_boards_web_portlet_MBAdminPortlet", "mvc.command.name=/message_boards/delete_thread"}, service={MVCActionCommand.class})
public class DeleteThreadMVCActionCommand
extends BaseMVCActionCommand {
    private MBThreadService _mbThreadService;

    protected void deleteThreads(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        long[] deleteThreadIds = null;
        long threadId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"threadId");
        deleteThreadIds = threadId > 0L ? new long[]{threadId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"threadIds"), (long)0L);
        ArrayList<MBThread> trashedModels = new ArrayList<MBThread>();
        for (long deleteThreadId : deleteThreadIds) {
            if (moveToTrash) {
                MBThread thread = this._mbThreadService.moveThreadToTrash(deleteThreadId);
                trashedModels.add(thread);
                continue;
            }
            this._mbThreadService.deleteThread(deleteThreadId);
        }
        if (moveToTrash && !trashedModels.isEmpty()) {
            HashMap<String, ArrayList<MBThread>> data = new HashMap<String, ArrayList<MBThread>>();
            data.put("trashedModels", trashedModels);
            this.addDeleteSuccessData((PortletRequest)actionRequest, data);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("delete")) {
                this.deleteThreads(actionRequest, false);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteThreads(actionRequest, true);
            }
        }
        catch (LockedThreadException | PrincipalException e) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            actionResponse.setRenderParameter("mvcPath", "/message_boards/error.jsp");
        }
    }

    @Reference(unbind="-")
    protected void setMBThreadService(MBThreadService mbThreadService) {
        this._mbThreadService = mbThreadService;
    }
}

