/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.portlet.action;

import com.liferay.message.boards.exception.NoSuchMessageException;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBMessageDisplay;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBBanLocalServiceUtil;
import com.liferay.message.boards.service.MBCategoryServiceUtil;
import com.liferay.message.boards.service.MBMessageServiceUtil;
import com.liferay.message.boards.service.MBThreadLocalServiceUtil;
import com.liferay.message.boards.web.internal.security.permission.MBResourcePermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class ActionUtil {
    public static MBCategory getCategory(HttpServletRequest request) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String mvcRenderCommandName = ParamUtil.getString((HttpServletRequest)request, (String)"mvcRenderCommandName");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (mvcRenderCommandName.equals("/message_boards/view_banned_users") && !MBResourcePermission.contains(permissionChecker, themeDisplay.getScopeGroupId(), "BAN_USER")) {
            throw new PrincipalException.MustHavePermission(permissionChecker, new String[]{"BAN_USER"});
        }
        MBBanLocalServiceUtil.checkBan((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId());
        long categoryId = ParamUtil.getLong((HttpServletRequest)request, (String)"mbCategoryId");
        MBCategory category = null;
        if (categoryId > 0L) {
            category = MBCategoryServiceUtil.getCategory((long)categoryId);
        } else {
            MBResourcePermission.check(permissionChecker, themeDisplay.getScopeGroupId(), "VIEW");
        }
        return category;
    }

    public static MBCategory getCategory(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getCategory(request);
    }

    public static MBMessage getMessage(HttpServletRequest request) throws Exception {
        long messageId = ParamUtil.getLong((HttpServletRequest)request, (String)"messageId");
        MBMessage message = null;
        if (messageId > 0L) {
            message = MBMessageServiceUtil.getMessage((long)messageId);
        }
        if (message != null && message.isInTrash()) {
            throw new NoSuchMessageException("{messageId=" + messageId + "}");
        }
        return message;
    }

    public static MBMessage getMessage(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getMessage(request);
    }

    public static MBMessageDisplay getMessageDisplay(HttpServletRequest request) throws PortalException {
        MBMessage message;
        MBMessageDisplay messageDisplay;
        long messageId = ParamUtil.getLong((HttpServletRequest)request, (String)"messageId");
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        int status = 0;
        if (permissionChecker.isContentReviewer(themeDisplay.getUserId(), themeDisplay.getScopeGroupId())) {
            status = -1;
        }
        if ((messageDisplay = MBMessageServiceUtil.getMessageDisplay((long)messageId, (int)status)) != null && (message = messageDisplay.getMessage()) != null && message.isInTrash()) {
            throw new NoSuchMessageException("{messageId=" + messageId + "}");
        }
        return messageDisplay;
    }

    public static MBMessageDisplay getMessageDisplay(PortletRequest portletRequest) throws PortalException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getMessageDisplay(request);
    }

    public static MBMessage getThreadMessage(HttpServletRequest request) throws Exception {
        long threadId = ParamUtil.getLong((HttpServletRequest)request, (String)"threadId");
        MBMessage message = null;
        if (threadId > 0L) {
            MBThread thread = MBThreadLocalServiceUtil.getThread((long)threadId);
            message = MBMessageServiceUtil.getMessage((long)thread.getRootMessageId());
        }
        if (message != null && message.isInTrash()) {
            throw new NoSuchMessageException("{threadId=" + threadId + "}");
        }
        return message;
    }

    public static MBMessage getThreadMessage(PortletRequest portletRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getThreadMessage(request);
    }
}

