/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.exportimport.data.handler;

import com.liferay.exportimport.kernel.lar.BasePortletDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.message.boards.model.MBBan;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.model.MBThreadFlag;
import com.liferay.message.boards.service.MBBanLocalService;
import com.liferay.message.boards.service.MBCategoryLocalService;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBStatsUserLocalService;
import com.liferay.message.boards.service.MBThreadFlagLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.PropsValues;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_message_boards_web_portlet_MBPortlet", "javax.portlet.name=com_liferay_message_boards_web_portlet_MBAdminPortlet"}, service={PortletDataHandler.class})
public class MBPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "message_boards";
    public static final String SCHEMA_VERSION = "1.0.0";
    private MBBanLocalService _mbBanLocalService;
    private MBCategoryLocalService _mbCategoryLocalService;
    private MBMessageLocalService _mbMessageLocalService;
    private MBStatsUserLocalService _mbStatsUserLocalService;
    private MBThreadFlagLocalService _mbThreadFlagLocalService;
    private MBThreadLocalService _mbThreadLocalService;
    @Reference
    private Staging _staging;

    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    public String getServiceName() {
        return "com.liferay.message.boards";
    }

    @Activate
    protected void activate() {
        this.setDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(MBBan.class), new StagedModelType(MBCategory.class), new StagedModelType(MBMessage.class), new StagedModelType(MBThread.class), new StagedModelType(MBThreadFlag.class)});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "categories", true, false, null, MBCategory.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "messages", true, false, null, MBMessage.class.getName(), "referrer-class-name-all"), new PortletDataHandlerBoolean(NAMESPACE, "thread-flags", true, false, null, MBThreadFlag.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "user-bans", true, false, null, MBBan.class.getName())});
        this.setPublishToLiveByDefault(PropsValues.MESSAGE_BOARDS_PUBLISH_TO_LIVE_BY_DEFAULT);
        this.setStagingControls(this.getExportControls());
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(MBPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        this._mbBanLocalService.deleteBansByGroupId(portletDataContext.getScopeGroupId());
        this._mbCategoryLocalService.deleteCategories(portletDataContext.getScopeGroupId());
        this._mbStatsUserLocalService.deleteStatsUsersByGroupId(portletDataContext.getScopeGroupId());
        this._mbThreadLocalService.deleteThreads(portletDataContext.getScopeGroupId(), 0L);
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPortletPermissions("com.liferay.message.boards");
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        if (portletDataContext.getBooleanParameter(NAMESPACE, "categories") || portletDataContext.getBooleanParameter(NAMESPACE, "messages")) {
            ExportActionableDynamicQuery categoryActionableDynamicQuery = this._mbCategoryLocalService.getExportActionableDynamicQuery(portletDataContext);
            categoryActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "messages")) {
            ActionableDynamicQuery messageActionableDynamicQuery = this.getMessageActionableDynamicQuery(portletDataContext);
            messageActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "thread-flags")) {
            ExportActionableDynamicQuery threadFlagActionableDynamicQuery = this._mbThreadFlagLocalService.getExportActionableDynamicQuery(portletDataContext);
            threadFlagActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "user-bans")) {
            ExportActionableDynamicQuery banActionableDynamicQuery = this._mbBanLocalService.getExportActionableDynamicQuery(portletDataContext);
            banActionableDynamicQuery.performActions();
        }
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPortletPermissions("com.liferay.message.boards");
        if (portletDataContext.getBooleanParameter(NAMESPACE, "categories") || portletDataContext.getBooleanParameter(NAMESPACE, "messages")) {
            Element categoriesElement = portletDataContext.getImportDataGroupElement(MBCategory.class);
            List categoryElements = categoriesElement.elements();
            for (Element categoryElement : categoryElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)categoryElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "messages")) {
            Element messagesElement = portletDataContext.getImportDataGroupElement(MBMessage.class);
            List messageElements = messagesElement.elements();
            for (Element messageElement : messageElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)messageElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "thread-flags")) {
            Element threadFlagsElement = portletDataContext.getImportDataGroupElement(MBThreadFlag.class);
            List threadFlagElements = threadFlagsElement.elements();
            for (Element threadFlagElement : threadFlagElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)threadFlagElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "user-bans")) {
            Element userBansElement = portletDataContext.getImportDataGroupElement(MBBan.class);
            List userBanElements = userBansElement.elements();
            for (Element userBanElement : userBanElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)userBanElement);
            }
        }
        return null;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        if (ExportImportDateUtil.isRangeFromLastPublishDate((PortletDataContext)portletDataContext)) {
            this._staging.populateLastPublishDateCounts(portletDataContext, new StagedModelType[]{new StagedModelType(MBBan.class.getName()), new StagedModelType(MBCategory.class.getName()), new StagedModelType(MBMessage.class.getName()), new StagedModelType(MBThread.class.getName()), new StagedModelType(MBThreadFlag.class.getName())});
            return;
        }
        ExportActionableDynamicQuery banActionableDynamicQuery = this._mbBanLocalService.getExportActionableDynamicQuery(portletDataContext);
        banActionableDynamicQuery.performCount();
        ExportActionableDynamicQuery categoryActionableDynamicQuery = this._mbCategoryLocalService.getExportActionableDynamicQuery(portletDataContext);
        categoryActionableDynamicQuery.performCount();
        ActionableDynamicQuery messageActionableDynamicQuery = this.getMessageActionableDynamicQuery(portletDataContext);
        messageActionableDynamicQuery.performCount();
        ExportActionableDynamicQuery threadActionableDynamicQuery = this._mbThreadLocalService.getExportActionableDynamicQuery(portletDataContext);
        threadActionableDynamicQuery.performCount();
        ExportActionableDynamicQuery threadFlagActionableDynamicQuery = this._mbThreadFlagLocalService.getExportActionableDynamicQuery(portletDataContext);
        threadFlagActionableDynamicQuery.performCount();
    }

    protected ActionableDynamicQuery getMessageActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery actionableDynamicQuery = this._mbMessageLocalService.getExportActionableDynamicQuery(portletDataContext);
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Criterion modifiedDateCriterion = portletDataContext.getDateRangeCriteria("modifiedDate");
                Criterion statusDateCriterion = portletDataContext.getDateRangeCriteria("statusDate");
                if (modifiedDateCriterion != null && statusDateCriterion != null) {
                    Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
                    disjunction.add(modifiedDateCriterion);
                    disjunction.add(statusDateCriterion);
                    dynamicQuery.add((Criterion)disjunction);
                }
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                dynamicQuery.add(classNameIdProperty.eq((Object)0L));
                Property statusProperty = PropertyFactoryUtil.forName((String)"status");
                if (portletDataContext.isInitialPublication()) {
                    dynamicQuery.add(statusProperty.ne((Object)8));
                } else {
                    StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)MBMessage.class.getName());
                    dynamicQuery.add(statusProperty.in(stagedModelDataHandler.getExportableStatuses()));
                }
            }
        });
        return actionableDynamicQuery;
    }

    @Reference(unbind="-")
    protected void setMBBanLocalService(MBBanLocalService mbBanLocalService) {
        this._mbBanLocalService = mbBanLocalService;
    }

    @Reference(unbind="-")
    protected void setMBCategoryLocalService(MBCategoryLocalService mbCategoryLocalService) {
        this._mbCategoryLocalService = mbCategoryLocalService;
    }

    @Reference(unbind="-")
    protected void setMBMessageLocalService(MBMessageLocalService mbMessageLocalService) {
        this._mbMessageLocalService = mbMessageLocalService;
    }

    @Reference(unbind="-")
    protected void setMBStatsUserLocalService(MBStatsUserLocalService mbStatsUserLocalService) {
        this._mbStatsUserLocalService = mbStatsUserLocalService;
    }

    @Reference(unbind="-")
    protected void setMBThreadFlagLocalService(MBThreadFlagLocalService mbThreadFlagLocalService) {
        this._mbThreadFlagLocalService = mbThreadFlagLocalService;
    }

    @Reference(unbind="-")
    protected void setMBThreadLocalService(MBThreadLocalService mbThreadLocalService) {
        this._mbThreadLocalService = mbThreadLocalService;
    }
}

