/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.display.context;

import com.liferay.message.boards.display.context.MBAdminListDisplayContext;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.MBCategoryServiceUtil;
import com.liferay.message.boards.service.MBThreadServiceUtil;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.search.SearchResultUtil;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultMBAdminListDisplayContext
implements MBAdminListDisplayContext {
    private static final UUID _UUID = UUID.fromString("f3efa0bd-ca31-43c5-bdfe-164ee683b39e");
    private final long _categoryId;
    private final HttpServletRequest _request;

    public DefaultMBAdminListDisplayContext(HttpServletRequest request, HttpServletResponse response, long categoryId) {
        this._request = request;
        this._categoryId = categoryId;
    }

    public int getEntriesDelta() {
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)this._request);
        return GetterUtil.getInteger((String)portalPreferences.getValue("com_liferay_message_boards_web_portlet_MBAdminPortlet", "entriesDelta"), (int)SearchContainer.DEFAULT_DELTA);
    }

    public UUID getUuid() {
        return _UUID;
    }

    public boolean isShowSearch() {
        String keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords");
        if (Validator.isNotNull((String)keywords)) {
            return true;
        }
        String mvcRenderCommandName = ParamUtil.getString((HttpServletRequest)this._request, (String)"mvcRenderCommandName");
        return mvcRenderCommandName.equals("/message_boards/search");
    }

    public void populateResultsAndTotal(SearchContainer searchContainer) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (this.isShowSearch()) {
            long searchCategoryId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"searchCategoryId");
            long[] categoryIdsArray = null;
            ArrayList<Long> categoryIds = new ArrayList<Long>();
            categoryIds.add(searchCategoryId);
            MBCategoryServiceUtil.getSubcategoryIds(categoryIds, (long)themeDisplay.getScopeGroupId(), (long)searchCategoryId);
            categoryIdsArray = StringUtil.split((String)StringUtil.merge(categoryIds), (long)0L);
            Indexer indexer = IndexerRegistryUtil.getIndexer(MBMessage.class);
            SearchContext searchContext = SearchContextFactory.getInstance((HttpServletRequest)this._request);
            searchContext.setAttribute("paginationType", (Serializable)((Object)"more"));
            searchContext.setCategoryIds(categoryIdsArray);
            searchContext.setEnd(searchContainer.getEnd());
            searchContext.setIncludeAttachments(true);
            String keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords");
            searchContext.setKeywords(keywords);
            String orderByCol = searchContainer.getOrderByCol();
            String orderByType = searchContainer.getOrderByType();
            Sort sort = null;
            boolean orderByAsc = true;
            if (Objects.equals(orderByType, "asc")) {
                orderByAsc = false;
            }
            if (Objects.equals(orderByCol, "modified-date")) {
                sort = new Sort("modified", 6, orderByAsc);
            } else if (Objects.equals(orderByCol, "title")) {
                String sortFieldName = Field.getSortableFieldName((String)"localized_title_".concat(themeDisplay.getLanguageId()));
                sort = new Sort(sortFieldName, 3, orderByAsc);
            }
            searchContext.setSorts(new Sort[]{sort});
            searchContext.setStart(searchContainer.getStart());
            Hits hits = indexer.search(searchContext);
            searchContainer.setResults(SearchResultUtil.getSearchResults((Hits)hits, (Locale)this._request.getLocale()));
            searchContainer.setTotal(hits.getLength());
        } else {
            String entriesNavigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"entriesNavigation", (String)"all");
            if ("all".equals(entriesNavigation)) {
                int status = 0;
                PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
                if (permissionChecker.isContentReviewer(themeDisplay.getCompanyId(), themeDisplay.getScopeGroupId())) {
                    status = -1;
                }
                QueryDefinition queryDefinition = new QueryDefinition(status, themeDisplay.getUserId(), true, searchContainer.getStart(), searchContainer.getEnd(), searchContainer.getOrderByComparator());
                searchContainer.setTotal(MBCategoryServiceUtil.getCategoriesAndThreadsCount((long)themeDisplay.getScopeGroupId(), (long)this._categoryId, (QueryDefinition)queryDefinition));
                searchContainer.setResults(MBCategoryServiceUtil.getCategoriesAndThreads((long)themeDisplay.getScopeGroupId(), (long)this._categoryId, (QueryDefinition)queryDefinition));
            } else if ("threads".equals(entriesNavigation)) {
                int status = 0;
                PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
                if (permissionChecker.isContentReviewer(themeDisplay.getCompanyId(), themeDisplay.getScopeGroupId())) {
                    status = -1;
                }
                QueryDefinition queryDefinition = new QueryDefinition(status, themeDisplay.getUserId(), true, searchContainer.getStart(), searchContainer.getEnd(), searchContainer.getOrderByComparator());
                searchContainer.setTotal(MBThreadServiceUtil.getThreadsCount((long)themeDisplay.getScopeGroupId(), (long)this._categoryId, (QueryDefinition)queryDefinition));
                searchContainer.setResults(MBThreadServiceUtil.getThreads((long)themeDisplay.getScopeGroupId(), (long)this._categoryId, (QueryDefinition)queryDefinition));
            } else if ("categories".equals(entriesNavigation)) {
                int status = 0;
                PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
                if (permissionChecker.isContentReviewer(themeDisplay.getCompanyId(), themeDisplay.getScopeGroupId())) {
                    status = -1;
                }
                QueryDefinition queryDefinition = new QueryDefinition(status, themeDisplay.getUserId(), true, searchContainer.getStart(), searchContainer.getEnd(), searchContainer.getOrderByComparator());
                searchContainer.setTotal(MBCategoryServiceUtil.getCategoriesCount((long)themeDisplay.getScopeGroupId(), (long)this._categoryId, (QueryDefinition)queryDefinition));
                searchContainer.setResults(MBCategoryServiceUtil.getCategories((long)themeDisplay.getScopeGroupId(), (long)this._categoryId, (QueryDefinition)queryDefinition));
            }
        }
    }

    public void setEntriesDelta(SearchContainer searchContainer) {
        int entriesDelta = ParamUtil.getInteger((HttpServletRequest)this._request, (String)searchContainer.getDeltaParam());
        if (entriesDelta > 0) {
            PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)this._request);
            portalPreferences.setValue("com_liferay_message_boards_web_portlet_MBAdminPortlet", "entriesDelta", String.valueOf(entriesDelta));
        }
    }
}

