/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.display;

import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.service.MBCategoryLocalServiceUtil;
import com.liferay.message.boards.service.MBCategoryServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListTree;
import com.liferay.portal.kernel.util.TreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MBCategoryDisplay {
    private static final Log _log = LogFactoryUtil.getLog(MBCategoryDisplay.class);
    private List<MBCategory> _allCategories;
    private Map<Long, TreeNode<MBCategory>> _categoryNodesMap;
    private ListTree<MBCategory> _categoryTree;
    private MBCategory _rootCategory;

    public MBCategoryDisplay(long scopeGroupId, long categoryId) {
        try {
            this.init(scopeGroupId, categoryId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public int getAllCategoriesCount() {
        return this._allCategories.size();
    }

    public int getSubcategoriesCount(MBCategory category) {
        TreeNode<MBCategory> node = this._categoryNodesMap.get(category.getCategoryId());
        List childNodes = this._categoryTree.getChildNodes(node);
        return childNodes.size();
    }

    public int getSubcategoriesMessagesCount(MBCategory category) {
        int count = category.getMessageCount();
        TreeNode<MBCategory> node = this._categoryNodesMap.get(category.getCategoryId());
        List childNodes = this._categoryTree.getChildNodes(node);
        for (TreeNode curNode : childNodes) {
            MBCategory curCategory = (MBCategory)curNode.getValue();
            count += curCategory.getMessageCount();
        }
        return count;
    }

    public int getSubcategoriesThreadsCount(MBCategory category) {
        int count = category.getThreadCount();
        TreeNode<MBCategory> node = this._categoryNodesMap.get(category.getCategoryId());
        List childNodes = this._categoryTree.getChildNodes(node);
        for (TreeNode curNode : childNodes) {
            MBCategory curCategory = (MBCategory)curNode.getValue();
            count += curCategory.getThreadCount();
        }
        return count;
    }

    protected void init(long scopeGroupId, long categoryId) throws Exception {
        this._allCategories = MBCategoryServiceUtil.getCategories((long)scopeGroupId, (int)0);
        if (categoryId != 0L) {
            this._rootCategory = MBCategoryLocalServiceUtil.fetchMBCategory((long)categoryId);
        }
        this._categoryTree = new ListTree((Comparable)this._rootCategory);
        this._categoryNodesMap = new HashMap<Long, TreeNode<MBCategory>>();
        HashMap<Long, List<MBCategory>> categoriesMap = new HashMap<Long, List<MBCategory>>();
        for (MBCategory category : this._allCategories) {
            Long parentCategoryId = category.getParentCategoryId();
            ArrayList<MBCategory> curCategories = (ArrayList<MBCategory>)categoriesMap.get(parentCategoryId);
            if (curCategories == null) {
                curCategories = new ArrayList<MBCategory>();
                categoriesMap.put(parentCategoryId, curCategories);
            }
            curCategories.add(category);
        }
        this.populateCategoryNodesMap((TreeNode<MBCategory>)this._categoryTree.getRootNode(), categoriesMap);
    }

    protected void populateCategoryNodesMap(TreeNode<MBCategory> node, Map<Long, List<MBCategory>> categoriesMap) {
        List<MBCategory> categories;
        MBCategory category = (MBCategory)node.getValue();
        long categoryId = 0L;
        if (category != null) {
            categoryId = category.getCategoryId();
        }
        if (categoryId == 0L) {
            this._categoryNodesMap.put(categoryId, node);
        }
        if ((categories = categoriesMap.get(categoryId)) == null) {
            return;
        }
        for (MBCategory curCategory : categories) {
            TreeNode curNode = node.addChildNode((Comparable)curCategory);
            this._categoryNodesMap.put(curCategory.getCategoryId(), (TreeNode<MBCategory>)curNode);
            this.populateCategoryNodesMap((TreeNode<MBCategory>)curNode, categoriesMap);
        }
    }

    private List<MBCategory> _getCategories(MBCategory category) {
        TreeNode<MBCategory> node = this._categoryNodesMap.get(category.getCategoryId());
        return node.getChildValues();
    }
}

