/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.asset;

import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseAssetRendererFactory;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.web.internal.asset.MBMessageAssetRenderer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_message_boards_web_portlet_MBPortlet"}, service={AssetRendererFactory.class})
public class MBMessageAssetRendererFactory
extends BaseAssetRendererFactory<MBMessage> {
    public static final String TYPE = "message";
    private MBMessageLocalService _mbMessageLocalService;
    @Reference(target="(model.class.name=com.liferay.message.boards.model.MBMessage)")
    private ModelResourcePermission<MBMessage> _messageModelResourcePermission;

    public MBMessageAssetRendererFactory() {
        this.setCategorizable(false);
        this.setLinkable(true);
        this.setPortletId("com_liferay_message_boards_web_portlet_MBPortlet");
        this.setSearchable(true);
    }

    public AssetRenderer<MBMessage> getAssetRenderer(long classPK, int type) throws PortalException {
        MBMessage message = this._mbMessageLocalService.getMessage(classPK);
        MBMessageAssetRenderer mbMessageAssetRenderer = new MBMessageAssetRenderer(message, this._messageModelResourcePermission);
        mbMessageAssetRenderer.setAssetRendererType(type);
        return mbMessageAssetRenderer;
    }

    public String getClassName() {
        return MBMessage.class.getName();
    }

    public String getIconCssClass() {
        return "comments";
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) {
        LiferayPortletURL liferayPortletURL = liferayPortletResponse.createLiferayPortletURL("com_liferay_message_boards_web_portlet_MBPortlet", "RENDER_PHASE");
        try {
            liferayPortletURL.setWindowState(windowState);
        }
        catch (WindowStateException windowStateException) {
            // empty catch block
        }
        return liferayPortletURL;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return this._messageModelResourcePermission.contains(permissionChecker, classPK, actionId);
    }

    @Reference(unbind="-")
    protected void setMBMessageLocalService(MBMessageLocalService mbMessageLocalService) {
        this._mbMessageLocalService = mbMessageLocalService;
    }
}

