/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.asset;

import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseAssetRendererFactory;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.service.MBCategoryLocalService;
import com.liferay.message.boards.web.internal.asset.MBCategoryAssetRenderer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_message_boards_web_portlet_MBPortlet"}, service={AssetRendererFactory.class})
public class MBCategoryAssetRendererFactory
extends BaseAssetRendererFactory<MBCategory> {
    public static final String TYPE = "category";
    @Reference(target="(model.class.name=com.liferay.message.boards.model.MBCategory)")
    private ModelResourcePermission<MBCategory> _categoryModelResourcePermission;
    private MBCategoryLocalService _mbCategoryLocalService;

    public MBCategoryAssetRendererFactory() {
        this.setCategorizable(false);
        this.setPortletId("com_liferay_message_boards_web_portlet_MBPortlet");
        this.setSelectable(false);
    }

    public AssetRenderer<MBCategory> getAssetRenderer(long classPK, int type) throws PortalException {
        MBCategory category = this._mbCategoryLocalService.getMBCategory(classPK);
        MBCategoryAssetRenderer mbCategoryAssetRenderer = new MBCategoryAssetRenderer(category, this._categoryModelResourcePermission);
        mbCategoryAssetRenderer.setAssetRendererType(type);
        return mbCategoryAssetRenderer;
    }

    public String getClassName() {
        return MBCategory.class.getName();
    }

    public String getIconCssClass() {
        return "comments";
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) {
        LiferayPortletURL liferayPortletURL = liferayPortletResponse.createLiferayPortletURL("com_liferay_message_boards_web_portlet_MBPortlet", "RENDER_PHASE");
        try {
            liferayPortletURL.setWindowState(windowState);
        }
        catch (WindowStateException windowStateException) {
            // empty catch block
        }
        return liferayPortletURL;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        MBCategory category = this._mbCategoryLocalService.getMBCategory(classPK);
        return this._categoryModelResourcePermission.contains(permissionChecker, (ClassedModel)category, actionId);
    }

    @Reference(unbind="-")
    protected void setMBCategoryLocalService(MBCategoryLocalService mbCategoryLocalService) {
        this._mbCategoryLocalService = mbCategoryLocalService;
    }
}

