/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.message.boards.exception.RequiredThreadException;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.uad.anonymizer.BaseMBThreadUADAnonymizer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.user.associated.data.anonymizer.UADAnonymizer;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={UADAnonymizer.class})
public class MBThreadUADAnonymizer
extends BaseMBThreadUADAnonymizer {
    @Reference
    private Language _language;
    @Reference
    private MBMessageLocalService _mbMessageLocalService;

    @Override
    public void delete(MBThread mbThread) throws PortalException {
        AssetEntry assetEntry;
        MBMessage message = this._mbMessageLocalService.getMessage(mbThread.getRootMessageId());
        if (message.isDiscussion() && (assetEntry = this.assetEntryLocalService.fetchEntry(message.getClassName(), message.getClassPK())).getUserId() != mbThread.getUserId()) {
            throw new RequiredThreadException();
        }
        super.delete(mbThread);
    }

    public Map<Class<?>, String> getExceptionMessageMap(Locale locale) {
        return HashMapBuilder.put(RequiredThreadException.class, (Object)this._language.get(locale, "thread-cannot-be-deleted.-anonymize-it-instead")).build();
    }
}

