/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.message.boards.model.MBSuspiciousActivity;
import com.liferay.message.boards.service.MBSuspiciousActivityLocalService;
import com.liferay.message.boards.uad.constants.MBUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseMBSuspiciousActivityUADAnonymizer
extends DynamicQueryUADAnonymizer<MBSuspiciousActivity> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected MBSuspiciousActivityLocalService mbSuspiciousActivityLocalService;

    public void autoAnonymize(MBSuspiciousActivity mbSuspiciousActivity, long userId, User anonymousUser) throws PortalException {
        if (mbSuspiciousActivity.getUserId() == userId) {
            mbSuspiciousActivity.setUserId(anonymousUser.getUserId());
            mbSuspiciousActivity.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(mbSuspiciousActivity, anonymousUser);
        }
        this.mbSuspiciousActivityLocalService.updateMBSuspiciousActivity(mbSuspiciousActivity);
    }

    public void delete(MBSuspiciousActivity mbSuspiciousActivity) throws PortalException {
        this.mbSuspiciousActivityLocalService.deleteMBSuspiciousActivity(mbSuspiciousActivity);
    }

    public Class<MBSuspiciousActivity> getTypeClass() {
        return MBSuspiciousActivity.class;
    }

    protected void autoAnonymizeAssetEntry(MBSuspiciousActivity mbSuspiciousActivity, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(mbSuspiciousActivity);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.mbSuspiciousActivityLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return MBUADConstants.USER_ID_FIELD_NAMES_MB_SUSPICIOUS_ACTIVITY;
    }

    protected AssetEntry fetchAssetEntry(MBSuspiciousActivity mbSuspiciousActivity) {
        return this.assetEntryLocalService.fetchEntry(MBSuspiciousActivity.class.getName(), mbSuspiciousActivity.getSuspiciousActivityId());
    }
}

