/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.service.MBCategoryLocalService;
import com.liferay.message.boards.uad.constants.MBUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseMBCategoryUADAnonymizer
extends DynamicQueryUADAnonymizer<MBCategory> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected MBCategoryLocalService mbCategoryLocalService;

    public void autoAnonymize(MBCategory mbCategory, long userId, User anonymousUser) throws PortalException {
        if (mbCategory.getUserId() == userId) {
            mbCategory.setUserId(anonymousUser.getUserId());
            mbCategory.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(mbCategory, anonymousUser);
        }
        if (mbCategory.getStatusByUserId() == userId) {
            mbCategory.setStatusByUserId(anonymousUser.getUserId());
            mbCategory.setStatusByUserName(anonymousUser.getFullName());
        }
        this.mbCategoryLocalService.updateMBCategory(mbCategory);
    }

    public void delete(MBCategory mbCategory) throws PortalException {
        this.mbCategoryLocalService.deleteCategory(mbCategory);
    }

    public Class<MBCategory> getTypeClass() {
        return MBCategory.class;
    }

    protected void autoAnonymizeAssetEntry(MBCategory mbCategory, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(mbCategory);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.mbCategoryLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return MBUADConstants.USER_ID_FIELD_NAMES_MB_CATEGORY;
    }

    protected AssetEntry fetchAssetEntry(MBCategory mbCategory) {
        return this.assetEntryLocalService.fetchEntry(MBCategory.class.getName(), mbCategory.getCategoryId());
    }
}

