/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.test.util;

import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.MBMessageLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MBTestUtil {
    public static MBMessage addMessage(long groupId, long userId, long categoryId, String subject, String body, ServiceContext serviceContext) throws PortalException {
        return MBMessageLocalServiceUtil.addMessage((long)userId, (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (long)groupId, (long)categoryId, (String)subject, (String)body, (ServiceContext)serviceContext);
    }

    public static MBMessage addMessage(long groupId, long userId, String subject, String body) throws PortalException {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId, (long)userId);
        return MBTestUtil.addMessage(groupId, userId, 0L, subject, body, serviceContext);
    }

    public static MBMessage addMessage(String subject, String body) throws PortalException {
        return MBTestUtil.addMessage(TestPropsValues.getGroupId(), TestPropsValues.getUserId(), subject, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MBMessage addMessageWithWorkflow(long groupId, long categoryId, String subject, String body, boolean approved, ServiceContext serviceContext) throws Exception {
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled((boolean)true);
            serviceContext = (ServiceContext)serviceContext.clone();
            serviceContext.setWorkflowAction(2);
            MBMessage message = MBTestUtil.addMessage(groupId, serviceContext.getUserId(), categoryId, subject, body, serviceContext);
            if (approved) {
                MBMessage mBMessage = MBTestUtil.updateStatus(message, serviceContext);
                return mBMessage;
            }
            MBMessage mBMessage = message;
            return mBMessage;
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    public static List<ObjectValuePair<String, InputStream>> getInputStreamOVPs(String fileName, Class<?> clazz, String keywords) {
        ArrayList<ObjectValuePair<String, InputStream>> inputStreamOVPs = new ArrayList<ObjectValuePair<String, InputStream>>(1);
        InputStream inputStream = clazz.getResourceAsStream("dependencies/" + fileName);
        ObjectValuePair inputStreamOVP = null;
        inputStreamOVP = Validator.isBlank((String)keywords) ? new ObjectValuePair((Object)fileName, (Object)inputStream) : new ObjectValuePair((Object)keywords, (Object)inputStream);
        inputStreamOVPs.add(inputStreamOVP);
        return inputStreamOVPs;
    }

    public static void populateNotificationsServiceContext(ServiceContext serviceContext, String command) throws Exception {
        serviceContext.setAttribute("entryURL", (Serializable)((Object)"http://localhost"));
        if (Validator.isNotNull((String)command)) {
            serviceContext.setCommand(command);
        }
        serviceContext.setLayoutFullURL("http://localhost");
    }

    protected static MBMessage updateStatus(MBMessage message, ServiceContext serviceContext) throws Exception {
        HashMap<String, String> workflowContext = new HashMap<String, String>();
        workflowContext.put("url", "http://localhost");
        message = MBMessageLocalServiceUtil.updateStatus((long)message.getUserId(), (long)message.getMessageId(), (int)0, (ServiceContext)serviceContext, workflowContext);
        return message;
    }
}

