/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.parser.bbcode.internal;

import com.liferay.message.boards.parser.bbcode.internal.BBCodeItem;
import com.liferay.message.boards.parser.bbcode.internal.BBCodeParser;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.parsers.bbcode.BBCodeTranslator;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.IntegerWrapper;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;

@Component(service={BBCodeTranslator.class})
public class HtmlBBCodeTranslatorImpl
implements BBCodeTranslator {
    private static final String[][] _EMOTICONS = new String[][]{{"happy.gif", ":)", "happy"}, {"smile.gif", ":D", "smile"}, {"cool.gif", "B)", "cool"}, {"sad.gif", ":(", "sad"}, {"tongue.gif", ":P", "tongue"}, {"laugh.gif", ":lol:", "laugh"}, {"kiss.gif", ":#", "kiss"}, {"blush.gif", ":*)", "blush"}, {"bashful.gif", ":bashful:", "bashful"}, {"smug.gif", ":smug:", "smug"}, {"blink.gif", ":blink:", "blink"}, {"huh.gif", ":huh:", "huh"}, {"mellow.gif", ":mellow:", "mellow"}, {"unsure.gif", ":unsure:", "unsure"}, {"mad.gif", ":mad:", "mad"}, {"oh_my.gif", ":O", "oh-my-goodness"}, {"roll_eyes.gif", ":rolleyes:", "roll-eyes"}, {"angry.gif", ":angry:", "angry"}, {"suspicious.gif", "8o", "suspicious"}, {"big_grin.gif", ":grin:", "grin"}, {"in_love.gif", ":love:", "in-love"}, {"bored.gif", ":bored:", "bored"}, {"closed_eyes.gif", "-_-", "closed-eyes"}, {"cold.gif", ":cold:", "cold"}, {"sleep.gif", ":sleep:", "sleep"}, {"glare.gif", ":glare:", "glare"}, {"darth_vader.gif", ":vader:", "darth-vader"}, {"dry.gif", ":dry:", "dry"}, {"exclamation.gif", ":what:", "what"}, {"girl.gif", ":girl:", "girl"}, {"karate_kid.gif", ":kid:", "karate-kid"}, {"ninja.gif", ":ph34r:", "ninja"}, {"pac_man.gif", ":V", "pac-man"}, {"wacko.gif", ":wacko:", "wacko"}, {"wink.gif", ":wink:", "wink"}, {"wub.gif", ":wub:", "wub"}};
    private static final int[] _FONT_SIZES = new int[]{10, 12, 14, 16, 18, 24, 32, 48};
    private static final Log _log = LogFactoryUtil.getLog(HtmlBBCodeTranslatorImpl.class);
    private static final Pattern _attributesPattern = Pattern.compile("\\s*([^=]+)\\s*=\\s*\"([^\"]+)\"\\s*");
    private static final Pattern _bbCodePattern = Pattern.compile("[]&<>'\"`\\[()]");
    private static final Pattern _colorPattern = Pattern.compile("^(:?aqua|black|blue|fuchsia|gray|green|lime|maroon|navy|olive|purple|red|silver|teal|white|yellow|#(?:[0-9a-f]{3})?[0-9a-f]{3})$", 2);
    private static final Pattern _imagePattern = Pattern.compile("^(?:https?://|/)[-;/?:@&=+$,_.!~*'()%0-9a-z]{1,2048}$", 2);
    private static final Pattern _urlPattern = Pattern.compile("^[-;/?:@&=+$,_.!~*'()%\\p{Digit}\\p{L}#]{1,2048}$", 2);
    private final Map<String, String> _bbCodeCharacters;
    private final BBCodeParser _bbCodeParser = new BBCodeParser();
    private final String[] _emoticonDescriptions = new String[_EMOTICONS.length];
    private final String[] _emoticonFiles = new String[_EMOTICONS.length];
    private final String[] _emoticonSymbols = new String[_EMOTICONS.length];
    private final Map<String, Integer> _excludeNewLineTypes;
    private final Set<String> _imageAttributes;
    private final Map<String, String> _orderedListStyles;
    private final Map<String, String> _unorderedListStyles;

    public HtmlBBCodeTranslatorImpl() {
        this._bbCodeCharacters = HashMapBuilder.put((Object)"&", (Object)"&amp;").put((Object)"'", (Object)"&#039;").put((Object)"(", (Object)"&#40;").put((Object)")", (Object)"&#41;").put((Object)"/", (Object)"&#047;").put((Object)"<", (Object)"&lt;").put((Object)">", (Object)"&gt;").put((Object)"[", (Object)"&#91;").put((Object)"\"", (Object)"&#034;").put((Object)"]", (Object)"&#93;").put((Object)"`", (Object)"&#096;").build();
        for (int i = 0; i < _EMOTICONS.length; ++i) {
            String[] emoticon = _EMOTICONS[i];
            this._emoticonDescriptions[i] = emoticon[2];
            this._emoticonFiles[i] = emoticon[0];
            this._emoticonSymbols[i] = emoticon[1];
            String image = emoticon[0];
            emoticon[0] = StringBundler.concat((String[])new String[]{"<img alt=\"emoticon\" src=\"", "@theme_images_path@", "/emoticons", "/", image, "\" >"});
        }
        this._excludeNewLineTypes = HashMapBuilder.put((Object)"*", (Object)3).put((Object)"li", (Object)3).put((Object)"table", (Object)2).put((Object)"td", (Object)3).put((Object)"th", (Object)3).put((Object)"tr", (Object)3).build();
        this._imageAttributes = new HashSet<String>(Arrays.asList("alt", "class", "dir", "height", "id", "lang", "longdesc", "style", "title", "width"));
        this._orderedListStyles = HashMapBuilder.put((Object)"1", (Object)"list-style: decimal outside;").put((Object)"a", (Object)"list-style: lower-alpha outside;").put((Object)"A", (Object)"list-style: upper-alpha outside;").put((Object)"i", (Object)"list-style: lower-roman outside;").put((Object)"I", (Object)"list-style: upper-roman outside;").build();
        this._unorderedListStyles = HashMapBuilder.put((Object)"circle", (Object)"list-style: circle outside;").put((Object)"disc", (Object)"list-style: disc outside;").put((Object)"square", (Object)"list-style: square outside;").build();
    }

    public String[] getEmoticonDescriptions() {
        return this._emoticonDescriptions;
    }

    public String[] getEmoticonFiles() {
        return this._emoticonFiles;
    }

    public String[][] getEmoticons() {
        return _EMOTICONS;
    }

    public String[] getEmoticonSymbols() {
        return this._emoticonSymbols;
    }

    public String getHTML(String bbcode) {
        try {
            bbcode = this.parse(bbcode);
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to parse: " + bbcode), (Throwable)exception);
            bbcode = HtmlUtil.escape((String)bbcode);
        }
        return bbcode;
    }

    public String parse(String text) {
        StringBundler sb = new StringBundler();
        List<BBCodeItem> bbCodeItems = this._bbCodeParser.parse(text);
        Stack<String> tags = new Stack<String>();
        IntegerWrapper marker = new IntegerWrapper();
        while (marker.getValue() < bbCodeItems.size()) {
            BBCodeItem bbCodeItem = bbCodeItems.get(marker.getValue());
            int type = bbCodeItem.getType();
            if (type == 4) {
                this.handleData(sb, bbCodeItems, tags, marker, bbCodeItem);
            } else if (type == 2) {
                this.handleTagEnd(sb, tags);
            } else if (type == 1) {
                this.handleTagStart(sb, bbCodeItems, tags, marker, bbCodeItem);
            }
            marker.increment();
        }
        return sb.toString();
    }

    protected void handleData(StringBundler sb, List<BBCodeItem> bbCodeItems, Stack<String> tags, IntegerWrapper marker, BBCodeItem bbCodeItem) {
        String value = HtmlUtil.escape((String)bbCodeItem.getValue());
        value = this._handleNewLine(bbCodeItems, marker, value);
        for (String[] emoticon : _EMOTICONS) {
            value = StringUtil.replace((String)value, (String)emoticon[1], (String)emoticon[0]);
        }
        sb.append(value);
    }

    protected void handleTagEnd(StringBundler sb, Stack<String> tags) {
        sb.append(tags.pop());
    }

    protected void handleTagStart(StringBundler sb, List<BBCodeItem> bbCodeItems, Stack<String> tags, IntegerWrapper marker, BBCodeItem bbCodeItem) {
        String tag = bbCodeItem.getValue();
        if (tag.equals("b")) {
            this._handleBold(sb, tags);
        } else if (tag.equals("center") || tag.equals("justify") || tag.equals("left") || tag.equals("right")) {
            this._handleTextAlign(sb, tags, bbCodeItem);
        } else if (tag.equals("code")) {
            this._handleCode(sb, bbCodeItems, marker);
        } else if (tag.equals("color") || tag.equals("colour")) {
            this._handleColor(sb, tags, bbCodeItem);
        } else if (tag.equals("email")) {
            this._handleEmail(sb, bbCodeItems, tags, marker, bbCodeItem);
        } else if (tag.equals("font")) {
            this._handleFontFamily(sb, tags, bbCodeItem);
        } else if (tag.equals("i")) {
            this._handleItalic(sb, tags);
        } else if (tag.equals("img")) {
            this._handleImage(sb, tags, bbCodeItems, marker);
        } else if (tag.equals("li") || tag.equals("*")) {
            this._handleListItem(sb, tags);
        } else if (tag.equals("list")) {
            this._handleList(sb, tags, bbCodeItem);
        } else if (tag.equals("q") || tag.equals("quote")) {
            this._handleQuote(sb, tags, bbCodeItem);
        } else if (tag.equals("s")) {
            this._handleStrikeThrough(sb, tags);
        } else if (tag.equals("size")) {
            this._handleFontSize(sb, tags, bbCodeItem);
        } else if (tag.equals("table")) {
            this._handleTable(sb, tags);
        } else if (tag.equals("td")) {
            this._handleTableCell(sb, tags);
        } else if (tag.equals("th")) {
            this._handleTableHeader(sb, tags);
        } else if (tag.equals("tr")) {
            this._handleTableRow(sb, tags);
        } else if (tag.equals("url")) {
            this._handleURL(sb, bbCodeItems, tags, marker, bbCodeItem);
        } else {
            this._handleSimpleTag(sb, tags, bbCodeItem);
        }
    }

    private String _escapeQuote(String quote) {
        StringBundler sb = new StringBundler();
        int index = 0;
        Matcher matcher = _bbCodePattern.matcher(quote);
        Collection<String> values = this._bbCodeCharacters.values();
        while (matcher.find()) {
            String value;
            String match = matcher.group();
            int matchStartIndex = matcher.start();
            int nextSemicolonIndex = quote.indexOf(";", matchStartIndex);
            sb.append(quote.substring(index, matchStartIndex));
            boolean entityFound = false;
            if (nextSemicolonIndex >= 0 && values.contains(value = quote.substring(matchStartIndex, nextSemicolonIndex + 1))) {
                sb.append(value);
                index = matchStartIndex + value.length();
                entityFound = true;
            }
            if (entityFound) continue;
            String escapedValue = this._bbCodeCharacters.get(match);
            sb.append(escapedValue);
            index = matchStartIndex + match.length();
        }
        if (index < quote.length()) {
            sb.append(quote.substring(index));
        }
        return sb.toString();
    }

    private String _extractData(List<BBCodeItem> bbCodeItems, IntegerWrapper marker, String tag, int type, boolean consume) {
        StringBundler sb = new StringBundler();
        int index = marker.getValue() + 1;
        BBCodeItem bbCodeItem = null;
        do {
            if (((bbCodeItem = bbCodeItems.get(index++)).getType() & type) <= 0) continue;
            sb.append(bbCodeItem.getValue());
        } while (bbCodeItem.getType() != 2 && !tag.equals(bbCodeItem.getValue()));
        if (consume) {
            marker.setValue(index - 1);
        }
        return sb.toString();
    }

    private void _handleBold(StringBundler sb, Stack<String> tags) {
        this._handleSimpleTag(sb, tags, "strong");
    }

    private void _handleCode(StringBundler sb, List<BBCodeItem> bbCodeItems, IntegerWrapper marker) {
        sb.append("<div class=\"lfr-code\"><table><tbody>");
        String code = this._extractData(bbCodeItems, marker, "code", 4, true);
        code = HtmlUtil.escape((String)code);
        code = StringUtil.replace((String)code, (char)'\t', (String)"    ");
        String[] lines = code.split("\r?\n");
        for (int i = 0; i < lines.length; ++i) {
            sb.append("<tr><td class=\"line-numbers\">");
            String index = String.valueOf(i + 1);
            sb.append(index);
            sb.append("</td><td class=\"lines\">");
            String line = lines[i];
            line = StringUtil.replace((String)line, (String)"   ", (String)"&nbsp; &nbsp;");
            line = StringUtil.replace((String)line, (String)"  ", (String)"&nbsp; ");
            if (Validator.isNull((String)line)) {
                line = "<br />";
            }
            sb.append("<div class=\"line\">");
            sb.append(line);
            sb.append("</div></td></tr>");
        }
        sb.append("</tbody></table></div>");
    }

    private void _handleColor(StringBundler sb, Stack<String> tags, BBCodeItem bbCodeItem) {
        sb.append("<span style=\"color: ");
        String color = bbCodeItem.getAttribute();
        if (color == null) {
            color = "inherit";
        } else {
            Matcher matcher = _colorPattern.matcher(color);
            if (!matcher.matches()) {
                color = "inherit";
            }
        }
        sb.append(color);
        sb.append("\">");
        tags.push("</span>");
    }

    private void _handleEmail(StringBundler sb, List<BBCodeItem> bbCodeItems, Stack<String> tags, IntegerWrapper marker, BBCodeItem bbCodeItem) {
        sb.append("<a href=\"");
        String href = bbCodeItem.getAttribute();
        if (href == null) {
            href = this._extractData(bbCodeItems, marker, "email", 4, false);
        }
        if (!href.startsWith("mailto:")) {
            href = "mailto:" + href;
        }
        sb.append(HtmlUtil.escapeHREF((String)href));
        sb.append("\">");
        tags.push("</a>");
    }

    private void _handleFontFamily(StringBundler sb, Stack<String> tags, BBCodeItem bbCodeItem) {
        sb.append("<span style=\"font-family: ");
        sb.append(HtmlUtil.escapeAttribute((String)bbCodeItem.getAttribute()));
        sb.append("\">");
        tags.push("</span>");
    }

    private void _handleFontSize(StringBundler sb, Stack<String> tags, BBCodeItem bbCodeItem) {
        sb.append("<span style=\"font-size: ");
        int size = GetterUtil.getInteger((String)bbCodeItem.getAttribute());
        if (size >= 1 && size <= _FONT_SIZES.length) {
            sb.append(_FONT_SIZES[size - 1]);
        } else {
            sb.append(_FONT_SIZES[1]);
        }
        sb.append("px;\">");
        tags.push("</span>");
    }

    private void _handleImage(StringBundler sb, Stack<String> tags, List<BBCodeItem> bbCodeItems, IntegerWrapper marker) {
        sb.append("<img src=\"");
        int pos = marker.getValue();
        String src = this._extractData(bbCodeItems, marker, "img", 4, true);
        Matcher matcher = _imagePattern.matcher(src);
        if (src.startsWith("data:image/") || matcher.matches()) {
            sb.append(HtmlUtil.escapeAttribute((String)src));
        }
        sb.append("\"");
        BBCodeItem bbCodeItem = bbCodeItems.get(pos);
        String attributes = bbCodeItem.getAttribute();
        if (Validator.isNotNull((String)attributes)) {
            sb.append(" ");
            this._handleImageAttributes(sb, attributes);
        }
        sb.append(" />");
        tags.push("");
    }

    private void _handleImageAttributes(StringBundler sb, String attributes) {
        Matcher matcher = _attributesPattern.matcher(attributes);
        while (matcher.find()) {
            String attributeName = matcher.group(1);
            if (!Validator.isNotNull((String)attributeName) || !this._imageAttributes.contains(StringUtil.toLowerCase((String)attributeName))) continue;
            String attributeValue = matcher.group(2);
            sb.append(" ");
            sb.append(attributeName);
            sb.append("=");
            sb.append("\"");
            sb.append(HtmlUtil.escapeAttribute((String)attributeValue));
            sb.append("\"");
        }
    }

    private void _handleItalic(StringBundler sb, Stack<String> tags) {
        this._handleSimpleTag(sb, tags, "em");
    }

    private void _handleList(StringBundler sb, Stack<String> tags, BBCodeItem bbCodeItem) {
        String tag = "ul";
        StringBundler attributesSB = new StringBundler();
        if (Validator.isNotNull((String)bbCodeItem.getAttribute())) {
            Matcher matcher = _attributesPattern.matcher(bbCodeItem.getAttribute());
            while (matcher.find()) {
                String attributeName = matcher.group(1);
                String attributeValue = matcher.group(2);
                if (Objects.equals(attributeName, "type")) {
                    String listStyle = null;
                    if (this._orderedListStyles.get(attributeValue) != null) {
                        listStyle = this._orderedListStyles.get(attributeValue);
                        tag = "ol";
                    } else {
                        listStyle = this._unorderedListStyles.get(attributeValue);
                    }
                    if (!Validator.isNotNull((String)listStyle)) continue;
                    attributesSB.append(" style=\"");
                    attributesSB.append(listStyle);
                    attributesSB.append("\"");
                    continue;
                }
                if (!Objects.equals(attributeName, "start") || !Validator.isNumber((String)attributeValue)) continue;
                attributesSB.append(" start=\"");
                attributesSB.append(attributeValue);
                attributesSB.append("\"");
            }
        }
        sb.append("<");
        sb.append(tag);
        sb.append(attributesSB);
        sb.append(">");
        tags.push("</" + tag + ">");
    }

    private void _handleListItem(StringBundler sb, Stack<String> tags) {
        this._handleSimpleTag(sb, tags, "li");
    }

    private String _handleNewLine(List<BBCodeItem> bbCodeItems, IntegerWrapper marker, String data) {
        if (marker.getValue() + 1 < bbCodeItems.size()) {
            String value;
            BBCodeItem bbCodeItem = null;
            if (data.matches("\\A\r?\n\\z")) {
                int excludeNewLineType;
                int type;
                String value2;
                bbCodeItem = bbCodeItems.get(marker.getValue() + 1);
                if (bbCodeItem != null && this._excludeNewLineTypes.containsKey(value2 = bbCodeItem.getValue()) && ((type = bbCodeItem.getType()) & (excludeNewLineType = this._excludeNewLineTypes.get(value2).intValue())) > 0) {
                    data = "";
                }
            } else if (data.matches("(?s).*\r?\n\\z") && (bbCodeItem = bbCodeItems.get(marker.getValue() + 1)) != null && bbCodeItem.getType() == 2 && (value = bbCodeItem.getValue()).equals("*")) {
                data = data.substring(0, data.length() - 1);
            }
        }
        if (data.length() > 0) {
            data = StringUtil.replace((String)data, (String)"\r\n", (String)"<br />");
            data = StringUtil.replace((String)data, (char)'\n', (String)"<br />");
        }
        return data;
    }

    private void _handleQuote(StringBundler sb, Stack<String> tags, BBCodeItem bbCodeItem) {
        String quote = bbCodeItem.getAttribute();
        if (quote != null && quote.length() > 0) {
            sb.append("<div class=\"quote-title\">");
            sb.append(this._escapeQuote(quote));
            sb.append(":</div>");
        }
        sb.append("<div class=\"quote\"><div class=\"quote-content\">");
        tags.push("</div></div>");
    }

    private void _handleSimpleTag(StringBundler sb, Stack<String> tags, BBCodeItem bbCodeItem) {
        this._handleSimpleTag(sb, tags, bbCodeItem.getValue());
    }

    private void _handleSimpleTag(StringBundler sb, Stack<String> tags, String tag) {
        sb.append("<");
        sb.append(tag);
        sb.append(">");
        tags.push("</" + tag + ">");
    }

    private void _handleStrikeThrough(StringBundler sb, Stack<String> tags) {
        this._handleSimpleTag(sb, tags, "strike");
    }

    private void _handleTable(StringBundler sb, Stack<String> tags) {
        this._handleSimpleTag(sb, tags, "table");
    }

    private void _handleTableCell(StringBundler sb, Stack<String> tags) {
        this._handleSimpleTag(sb, tags, "td");
    }

    private void _handleTableHeader(StringBundler sb, Stack<String> tags) {
        this._handleSimpleTag(sb, tags, "th");
    }

    private void _handleTableRow(StringBundler sb, Stack<String> tags) {
        this._handleSimpleTag(sb, tags, "tr");
    }

    private void _handleTextAlign(StringBundler sb, Stack<String> tags, BBCodeItem bbCodeItem) {
        sb.append("<p style=\"text-align: ");
        sb.append(bbCodeItem.getValue());
        sb.append("\">");
        tags.push("</p>");
    }

    private void _handleURL(StringBundler sb, List<BBCodeItem> bbCodeItems, Stack<String> tags, IntegerWrapper marker, BBCodeItem bbCodeItem) {
        Matcher matcher;
        sb.append("<a href=\"");
        String href = bbCodeItem.getAttribute();
        if (href == null) {
            href = this._extractData(bbCodeItems, marker, "url", 4, false);
        }
        if ((matcher = _urlPattern.matcher(href)).matches()) {
            sb.append(HtmlUtil.escapeHREF((String)href));
        }
        sb.append("\">");
        tags.push("</a>");
    }
}

