/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.parser.bbcode.internal;

import com.liferay.message.boards.parser.bbcode.internal.BBCodeItem;
import com.liferay.message.boards.parser.bbcode.internal.BBCodeLexer;
import com.liferay.message.boards.parser.bbcode.internal.BBCodeToken;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.IntegerWrapper;
import com.liferay.portal.kernel.util.SetUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BBCodeParser {
    public static final int TYPE_DATA = 4;
    public static final int TYPE_TAG_END = 2;
    public static final int TYPE_TAG_START = 1;
    public static final int TYPE_TAG_START_END = 3;
    private static final Pattern _tagPattern = Pattern.compile("^/?(?:b|center|code|colou?r|email|font|i|img|justify|left|li|list|pre|q|quote|right|s|size|table|td|th|tr|u|url|\\*)$", 2);
    private final Set<String> _blockElements = SetUtil.fromArray((Object[])new String[]{"*", "center", "code", "justify", "left", "li", "list", "q", "quote", "right", "table", "td", "th", "tr"});
    private final Set<String> _inlineElements = SetUtil.fromArray((Object[])new String[]{"b", "color", "font", "i", "img", "s", "size", "u", "url"});
    private final Set<String> _selfCloseElements = SetUtil.fromArray((Object[])new String[]{"*"});

    public List<BBCodeItem> parse(String text) {
        ArrayList<BBCodeItem> bbCodeItems = new ArrayList<BBCodeItem>();
        BBCodeLexer bbCodeLexer = new BBCodeLexer(text);
        Stack<String> tags = new Stack<String>();
        IntegerWrapper marker = new IntegerWrapper();
        BBCodeToken bbCodeToken = null;
        while ((bbCodeToken = bbCodeLexer.getNextBBCodeToken()) != null) {
            String endTag;
            this.handleData(bbCodeItems, bbCodeLexer, marker, bbCodeToken, text);
            if (bbCodeToken.getStartTag() == null) {
                this.handleTagEnd(bbCodeItems, tags, bbCodeToken);
                continue;
            }
            this.handleTagStart(bbCodeItems, tags, bbCodeToken);
            String startTag = bbCodeToken.getStartTag();
            if (!startTag.equals("code")) continue;
            while ((bbCodeToken = bbCodeLexer.getNextBBCodeToken()) != null && !(endTag = GetterUtil.getString((String)bbCodeToken.getEndTag())).equals("code")) {
            }
            this.handleData(bbCodeItems, bbCodeLexer, marker, bbCodeToken, text);
            if (bbCodeToken == null) break;
            this.handleTagEnd(bbCodeItems, tags, bbCodeToken);
        }
        this.handleData(bbCodeItems, bbCodeLexer, marker, null, text);
        this.handleTagEnd(bbCodeItems, tags, null);
        return bbCodeItems;
    }

    protected void handleData(List<BBCodeItem> bbCodeItems, BBCodeLexer bbCodeLexer, IntegerWrapper marker, BBCodeToken bbCodeToken, String data) {
        int length;
        int lastIndex = length = data.length();
        if (bbCodeToken != null) {
            length = lastIndex = bbCodeLexer.getLastIndex();
            String tag = bbCodeToken.getStartTag();
            if (tag == null) {
                tag = bbCodeToken.getEndTag();
            }
            if (this._isValidTag(tag)) {
                length = bbCodeToken.getStart();
            }
        }
        if (length > marker.getValue()) {
            BBCodeItem bbCodeItem = new BBCodeItem(4, null, data.substring(marker.getValue(), length));
            bbCodeItems.add(bbCodeItem);
        }
        marker.setValue(lastIndex);
    }

    protected void handleTagEnd(List<BBCodeItem> bbCodeItems, Stack<String> tags, BBCodeToken bbCodeToken) {
        int size = 0;
        if (bbCodeToken != null) {
            String endTag = bbCodeToken.getEndTag();
            for (size = tags.size() - 1; size >= 0 && !endTag.equals(tags.elementAt(size)); --size) {
            }
        }
        if (size >= 0) {
            for (int i = tags.size() - 1; i >= size; --i) {
                BBCodeItem bbCodeItem = new BBCodeItem(2, null, (String)tags.elementAt(i));
                bbCodeItems.add(bbCodeItem);
            }
            tags.setSize(size);
        }
    }

    protected void handleTagStart(List<BBCodeItem> bbCodeItems, Stack<String> tags, BBCodeToken bbCodeToken) {
        String startTag = bbCodeToken.getStartTag();
        if (!this._isValidTag(startTag)) {
            return;
        }
        if (!tags.isEmpty()) {
            if (this._blockElements.contains(startTag)) {
                String currentTag = null;
                while (!tags.isEmpty() && (currentTag = (String)tags.lastElement()) != null && this._inlineElements.contains(currentTag)) {
                    BBCodeToken currentTagBBCodeToken = new BBCodeToken(currentTag);
                    this.handleTagEnd(bbCodeItems, tags, currentTagBBCodeToken);
                }
            }
            if (!tags.isEmpty() && this._selfCloseElements.contains(startTag) && startTag.equals(tags.lastElement())) {
                BBCodeToken tagBBCodeToken = new BBCodeToken(startTag);
                this.handleTagEnd(bbCodeItems, tags, tagBBCodeToken);
            }
        }
        tags.push(startTag);
        BBCodeItem bbCodeItem = new BBCodeItem(1, bbCodeToken.getAttribute(), startTag);
        bbCodeItems.add(bbCodeItem);
    }

    private boolean _isValidTag(String tag) {
        if (tag != null && tag.length() > 0) {
            Matcher matcher = _tagPattern.matcher(tag);
            return matcher.matches();
        }
        return false;
    }
}

