/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.util;

import com.liferay.message.boards.constants.MBMessageConstants;
import com.liferay.message.boards.model.MBBan;
import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.parsers.bbcode.BBCodeTranslatorUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Calendar;
import java.util.Date;

public class MBUtil {
    public static final String BB_CODE_EDITOR_WYSIWYG_IMPL_KEY = "editor.wysiwyg.portal-web.docroot.html.portlet.message_boards.edit_message.bb_code.jsp";
    public static final String EMOTICONS = "/emoticons";
    private static final Log _log = LogFactoryUtil.getLog(MBUtil.class);

    public static String getBBCodeHTML(String msgBody, String pathThemeImages) {
        return StringUtil.replace((String)BBCodeTranslatorUtil.getHTML((String)msgBody), (String)"@theme_images_path@/emoticons", (String)(pathThemeImages + EMOTICONS));
    }

    public static String getSubscriptionClassName(String className) {
        if (className.startsWith(MBDiscussion.class.getName())) {
            return className;
        }
        return StringBundler.concat((String[])new String[]{MBDiscussion.class.getName(), "_", className});
    }

    public static Date getUnbanDate(MBBan ban, int expireInterval) {
        Date banDate = ban.getCreateDate();
        Calendar cal = Calendar.getInstance();
        cal.setTime(banDate);
        cal.add(5, expireInterval);
        return cal.getTime();
    }

    public static boolean isValidMessageFormat(String messageFormat) {
        String editorName = PropsUtil.get((String)BB_CODE_EDITOR_WYSIWYG_IMPL_KEY);
        if (editorName.equals("bbcode")) {
            editorName = "alloyeditor_bbcode";
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Replacing unsupported BBCode editor with AlloyEditor BBCode");
            }
        }
        if (messageFormat.equals("bbcode") && !editorName.equals("alloyeditor_bbcode") && !editorName.equals("ckeditor_bbcode")) {
            return false;
        }
        return ArrayUtil.contains((Object[])MBMessageConstants.FORMATS, (Object)messageFormat);
    }
}

