/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service.permission;

import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.MBBanLocalService;
import com.liferay.message.boards.service.MBDiscussionLocalService;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionCheckerUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermission;
import com.liferay.portal.util.PropsValues;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.message.boards.model.MBDiscussion"}, service={BaseModelPermissionChecker.class})
public class MBDiscussionPermission
implements BaseModelPermissionChecker {
    private static MBBanLocalService _mbBanLocalService;
    private static MBDiscussionLocalService _mbDiscussionLocalService;
    private static MBMessageLocalService _mbMessageLocalService;
    private static WorkflowPermission _workflowPermission;

    public static void check(PermissionChecker permissionChecker, long companyId, long groupId, String className, long classPK, String actionId) throws PortalException {
        if (!MBDiscussionPermission.contains(permissionChecker, companyId, groupId, className, classPK, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, className, classPK, new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long messageId, String actionId) throws PortalException {
        if (!MBDiscussionPermission.contains(permissionChecker, messageId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, MBMessage.class.getName(), messageId, new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long companyId, long groupId, String className, long classPK, String actionId) {
        if (_mbBanLocalService.hasBan(groupId, permissionChecker.getUserId())) {
            return false;
        }
        List resourceActions = ResourceActionsUtil.getResourceActions((String)className);
        if (!resourceActions.contains(actionId)) {
            return true;
        }
        Boolean hasPermission = BaseModelPermissionCheckerUtil.containsBaseModelPermission((PermissionChecker)permissionChecker, (long)groupId, (String)className, (long)classPK, (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        return permissionChecker.hasPermission(groupId, className, classPK, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long messageId, String actionId) throws PortalException {
        return MBDiscussionPermission.contains(permissionChecker, _mbMessageLocalService.getMessage(messageId), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, MBMessage message, String actionId) throws PortalException {
        Boolean hasPermission;
        String className = message.getClassName();
        if (className.equals(WorkflowInstance.class.getName())) {
            return permissionChecker.hasPermission(message.getGroupId(), "com_liferay_portal_workflow_definition_web_portlet_WorkflowDefinitionPortlet", message.getGroupId(), "VIEW");
        }
        if (PropsValues.DISCUSSION_COMMENTS_ALWAYS_EDITABLE_BY_OWNER && permissionChecker.getUserId() == message.getUserId()) {
            return true;
        }
        if (message.isPending() && (hasPermission = _workflowPermission.hasPermission(permissionChecker, message.getGroupId(), message.getWorkflowClassName(), message.getMessageId(), actionId)) != null) {
            return hasPermission;
        }
        return MBDiscussionPermission.contains(permissionChecker, message.getCompanyId(), message.getGroupId(), className, message.getClassPK(), actionId);
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        MBDiscussion mbDiscussion = _mbDiscussionLocalService.getMBDiscussion(primaryKey);
        MBDiscussionPermission.check(permissionChecker, mbDiscussion.getCompanyId(), groupId, mbDiscussion.getClassName(), mbDiscussion.getClassPK(), actionId);
    }

    @Reference(unbind="-")
    protected void setMBBanLocalService(MBBanLocalService mbBanLocalService) {
        _mbBanLocalService = mbBanLocalService;
    }

    @Reference(unbind="-")
    protected void setMBDiscussionLocalService(MBDiscussionLocalService mbDiscussionLocalService) {
        _mbDiscussionLocalService = mbDiscussionLocalService;
    }

    @Reference(unbind="-")
    protected void setMBMessageLocalService(MBMessageLocalService mbMessageLocalService) {
        _mbMessageLocalService = mbMessageLocalService;
    }

    @Reference(unbind="-")
    protected void setWorkflowPermission(WorkflowPermission workflowPermission) {
        _workflowPermission = workflowPermission;
    }
}

