/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mentions.web.internal.portlet;

import com.liferay.mentions.util.MentionsUserFinder;
import com.liferay.mentions.util.MentionsUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.social.kernel.util.SocialInteractionsConfiguration;
import com.liferay.social.kernel.util.SocialInteractionsConfigurationUtil;
import com.liferay.taglib.ui.UserPortraitTag;
import java.util.List;
import javax.portlet.Portlet;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.add-default-resource=true", "com.liferay.portlet.display-category=category.hidden", "com.liferay.portlet.icon=/icons/mentions.png", "javax.portlet.display-name=Mentions", "javax.portlet.expiration-cache=0", "javax.portlet.name=com_liferay_mentions_web_portlet_MentionsPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class MentionsPortlet
extends MVCPortlet {
    private static final Log _log = LogFactoryUtil.getLog(MentionsPortlet.class);
    @Reference
    private MentionsUserFinder _mentionsUserFinder;
    @Reference
    private Portal _portal;

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (!MentionsUtil.isMentionsEnabled((long)themeDisplay.getSiteGroupId())) {
                return;
            }
            HttpServletRequest httpServletRequest = this._portal.getHttpServletRequest((PortletRequest)resourceRequest);
            JSONArray jsonArray = this._getJSONArray(httpServletRequest);
            HttpServletResponse httpServletResponse = this._portal.getHttpServletResponse((PortletResponse)resourceResponse);
            httpServletResponse.setContentType("application/json");
            ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)jsonArray.toString());
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    private JSONArray _getJSONArray(HttpServletRequest httpServletRequest) throws PortalException {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        SocialInteractionsConfiguration socialInteractionsConfiguration = SocialInteractionsConfigurationUtil.getSocialInteractionsConfiguration((long)themeDisplay.getCompanyId(), (String)"com_liferay_mentions_web_portlet_MentionsPortlet");
        String query = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"query");
        List users = this._mentionsUserFinder.getUsers(themeDisplay.getCompanyId(), themeDisplay.getUserId(), query, socialInteractionsConfiguration);
        for (User user : users) {
            if (user.isDefaultUser() || themeDisplay.getUserId() == user.getUserId()) continue;
            JSONObject jsonObject = JSONUtil.put((String)"fullName", (Object)user.getFullName());
            String mention = "@" + user.getScreenName();
            String profileURL = user.getDisplayURL(themeDisplay);
            if (Validator.isNotNull((String)profileURL)) {
                mention = StringBundler.concat((String[])new String[]{"<a href=\"", profileURL, "\">@", user.getScreenName(), "</a>"});
            }
            jsonObject.put("mention", mention).put("portraitHTML", UserPortraitTag.getUserPortraitHTML((String)"", (User)user, (ThemeDisplay)themeDisplay)).put("screenName", user.getScreenName());
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }
}

