/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mentions.web.internal.notifications;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.notifications.BaseModelUserNotificationHandler;
import com.liferay.portal.kernel.notifications.UserNotificationHandler;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_mentions_web_portlet_MentionsPortlet"}, service={UserNotificationHandler.class})
public class MentionsUserNotificationHandler
extends BaseModelUserNotificationHandler {
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private Portal _portal;

    public MentionsUserNotificationHandler() {
        this.setPortletId("com_liferay_mentions_web_portlet_MentionsPortlet");
    }

    protected AssetRenderer<?> getAssetRenderer(JSONObject jsonObject) {
        MBMessage mbMessage = this._mbMessageLocalService.fetchMBMessage(jsonObject.getLong("classPK"));
        if (mbMessage != null && mbMessage.isDiscussion()) {
            return this.getAssetRenderer(mbMessage.getClassName(), mbMessage.getClassPK());
        }
        return this.getAssetRenderer(jsonObject.getString("className"), jsonObject.getLong("classPK"));
    }

    protected String getTitle(JSONObject jsonObject, AssetRenderer<?> assetRenderer, ServiceContext serviceContext) {
        MBMessage mbMessage = this._mbMessageLocalService.fetchMBMessage(jsonObject.getLong("classPK"));
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)assetRenderer.getClassName());
        String typeName = assetRendererFactory.getTypeName(serviceContext.getLocale());
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)serviceContext.getLocale(), ((Object)((Object)this)).getClass());
        if (mbMessage != null && mbMessage.isDiscussion()) {
            return LanguageUtil.format((ResourceBundle)resourceBundle, (String)"x-mentioned-you-in-a-comment-in-a-x", (Object[])new String[]{HtmlUtil.escape((String)this._portal.getUserName(jsonObject.getLong("userId"), "")), StringUtil.toLowerCase((String)HtmlUtil.escape((String)typeName))}, (boolean)false);
        }
        return LanguageUtil.format((ResourceBundle)resourceBundle, (String)"x-mentioned-you-in-a-x", (Object[])new String[]{HtmlUtil.escape((String)this._portal.getUserName(jsonObject.getLong("userId"), "")), StringUtil.toLowerCase((String)HtmlUtil.escape((String)typeName))}, (boolean)false);
    }

    @Reference(unbind="-")
    protected void setMBMessageLocalService(MBMessageLocalService mbMessageLocalService) {
        this._mbMessageLocalService = mbMessageLocalService;
    }
}

