/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.media.object.apio.internal.architect.router;

import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.router.NestedCollectionRouter;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.folder.apio.architect.identifier.FolderIdentifier;
import com.liferay.media.object.apio.architect.identifier.MediaObjectIdentifier;
import com.liferay.media.object.apio.internal.architect.form.MediaObjectCreatorForm;
import com.liferay.media.object.apio.internal.helper.MediaObjectHelper;
import com.liferay.portal.apio.permission.HasPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class FolderMediaObjectNestedCollectionRouter
implements NestedCollectionRouter<FileEntry, Long, MediaObjectIdentifier, Long, FolderIdentifier> {
    @Reference
    private DLAppService _dlAppService;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.repository.model.FileEntry)")
    private HasPermission<Long> _hasPermission;
    @Reference
    private MediaObjectHelper _mediaObjectHelper;

    public NestedCollectionRoutes<FileEntry, Long, Long> collectionRoutes(NestedCollectionRoutes.Builder<FileEntry, Long, Long> builder) {
        return builder.addGetter(this::_getPageItems).addCreator(this::_getFileEntry, this._hasPermission.forAddingIn(FolderIdentifier.class), MediaObjectCreatorForm::buildForm).build();
    }

    private FileEntry _getFileEntry(long folderId, MediaObjectCreatorForm mediaObjectCreatorForm) throws Exception {
        Folder folder = this._dlAppService.getFolder(folderId);
        return this._mediaObjectHelper.addFileEntry(folder.getRepositoryId(), folderId, mediaObjectCreatorForm);
    }

    private PageItems<FileEntry> _getPageItems(Pagination pagination, long folderId) throws PortalException {
        Folder folder = this._dlAppService.getFolder(folderId);
        List fileEntries = this._dlAppService.getFileEntries(folder.getGroupId(), folderId, pagination.getStartPosition(), pagination.getEndPosition(), null);
        int count = this._dlAppService.getFileEntriesCount(folder.getGroupId(), folderId);
        return new PageItems((Collection)fileEntries, count);
    }
}

