/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.media.object.apio.internal.architect.resource;

import com.liferay.apio.architect.file.BinaryFile;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.resource.NestedCollectionResource;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.asset.kernel.model.AssetTagModel;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.category.apio.architect.identifier.CategoryIdentifier;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.folder.apio.architect.identifier.FolderIdentifier;
import com.liferay.folder.apio.architect.identifier.RootFolderIdentifier;
import com.liferay.media.object.apio.architect.identifier.MediaObjectIdentifier;
import com.liferay.media.object.apio.internal.architect.form.MediaObjectCreatorForm;
import com.liferay.media.object.apio.internal.helper.MediaObjectHelper;
import com.liferay.person.apio.architect.identifier.PersonIdentifier;
import com.liferay.portal.apio.idempotent.Idempotent;
import com.liferay.portal.apio.permission.HasPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.StagedGroupedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class MediaObjectNestedCollectionResource
implements NestedCollectionResource<FileEntry, Long, MediaObjectIdentifier, Long, RootFolderIdentifier> {
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private DLAppService _dlAppService;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.repository.model.FileEntry)")
    private HasPermission<Long> _hasPermission;
    @Reference
    private MediaObjectHelper _mediaObjectHelper;

    public NestedCollectionRoutes<FileEntry, Long, Long> collectionRoutes(NestedCollectionRoutes.Builder<FileEntry, Long, Long> builder) {
        return builder.addGetter(this::_getPageItems).addCreator(this::_getFileEntry, this._hasPermission.forAddingIn(RootFolderIdentifier.class), MediaObjectCreatorForm::buildForm).build();
    }

    public String getName() {
        return "media-object";
    }

    public ItemRoutes<FileEntry, Long> itemRoutes(ItemRoutes.Builder<FileEntry, Long> builder) {
        return builder.addGetter(arg_0 -> ((DLAppService)this._dlAppService).getFileEntry(arg_0)).addRemover(Idempotent.idempotent(arg_0 -> ((DLAppService)this._dlAppService).deleteFileEntry(arg_0)), (arg_0, arg_1) -> this._hasPermission.forDeleting(arg_0, arg_1)).build();
    }

    public Representor<FileEntry> representor(Representor.Builder<FileEntry, Long> builder) {
        return (Representor)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)builder.types("MediaObject", new String[0]).identifier(FileEntry::getFileEntryId).addBidirectionalModel("folder", "mediaObjects", FolderIdentifier.class, FileEntry::getFolderId).addBinary("contentStream", this::_getBinaryFile)).addDate("dateCreated", FileEntry::getCreateDate)).addDate("dateModified", FileEntry::getModifiedDate)).addDate("datePublished", StagedGroupedModel::getLastPublishDate)).addLinkedModel("author", PersonIdentifier.class, FileEntry::getUserId)).addNumber("contentSize", FileEntry::getSize)).addRelatedCollection("categories", CategoryIdentifier.class).addString("fileFormat", FileEntry::getMimeType)).addString("headline", FileEntry::getTitle)).addString("name", FileEntry::getFileName)).addString("text", FileEntry::getDescription)).addStringList("keywords", this::_getMediaObjectAssetTags)).build();
    }

    private BinaryFile _getBinaryFile(FileEntry fileEntry) {
        return (BinaryFile)Try.fromFallible(() -> new BinaryFile(fileEntry.getContentStream(), Long.valueOf(fileEntry.getSize()), fileEntry.getMimeType())).orElse(null);
    }

    private FileEntry _getFileEntry(long groupId, MediaObjectCreatorForm mediaObjectCreatorForm) throws PortalException {
        return this._mediaObjectHelper.addFileEntry(groupId, 0L, mediaObjectCreatorForm);
    }

    private List<String> _getMediaObjectAssetTags(FileEntry fileEntry) {
        List assetTags = this._assetTagLocalService.getTags(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
        return ListUtil.toList((List)assetTags, AssetTagModel::getName);
    }

    private PageItems<FileEntry> _getPageItems(Pagination pagination, long groupId) throws PortalException {
        List fileEntries = this._dlAppService.getFileEntries(groupId, 0L, pagination.getStartPosition(), pagination.getEndPosition(), null);
        int count = this._dlAppService.getFileEntriesCount(groupId, 0L);
        return new PageItems((Collection)fileEntries, count);
    }
}

