/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.maven.executor;

import com.liferay.maven.executor.internal.FileUtil;
import com.liferay.maven.executor.internal.Validator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.junit.rules.ExternalResource;

public class MavenExecutor
extends ExternalResource {
    private static final String _LIFERAY_NEXUS_PROFILE_ID = "liferay";
    private static final String _LIFERAY_NEXUS_REPO_ID = "liferayRepo";
    private static final String _LIFERAY_NEXUS_REPO_URL = "https://repository.liferay.com/nexus/content/repositories/public";
    private static final String _LIFERAY_NEXUS_URL = "https://repository.liferay.com/nexus/content/repositories/";
    private static final String _XANADU_NEXUS_PROFILE_ID = "xanadu";
    private static final String _XANADU_NEXUS_REPO_ID = "xanaduRepo";
    private static final String _XANADU_NEXUS_REPO_URL = "https://repository.liferay.com/nexus/content/repositories/xanadu";
    private Path _mavenHomeDirPath;

    public Result execute(File projectDir, String ... args) throws Exception {
        Path mavenHomeDirPath = this._checkMavenHomeDirPath();
        ArrayList<String> commands = new ArrayList<String>();
        String mavenExecutableFileName = "mvn";
        boolean mavenDebug = this.isMavenDebug();
        if (mavenDebug) {
            mavenExecutableFileName = "mvnDebug";
        }
        if (this._isWindows()) {
            mavenExecutableFileName = mavenExecutableFileName + ".cmd";
        }
        Path mavenExecutablePath = mavenHomeDirPath.resolve("bin/" + mavenExecutableFileName);
        commands.add(String.valueOf(mavenExecutablePath.toAbsolutePath()));
        commands.add("--errors");
        for (String arg : args) {
            commands.add(arg);
        }
        this.writeSettingsXmlFile();
        ProcessBuilder processBuilder = new ProcessBuilder(commands);
        processBuilder.directory(projectDir);
        if (mavenDebug) {
            processBuilder.inheritIO();
        }
        Map<String, String> environment = processBuilder.environment();
        environment.put("M2_HOME", String.valueOf(mavenHomeDirPath.toAbsolutePath()));
        environment.put("MAVEN_OPTS", this.getMavenOpts());
        Process process = processBuilder.start();
        StringBuilder sb = new StringBuilder();
        this._append(sb, process.getInputStream());
        this._append(sb, process.getErrorStream());
        int exitCode = process.waitFor();
        return new Result(exitCode, sb.toString());
    }

    public String getHttpNonProxyHosts() {
        return System.getProperty("http.nonProxyHosts");
    }

    public String getHttpProxyHost() {
        return System.getProperty("http.proxyHost");
    }

    public String getHttpProxyPassword() {
        return System.getProperty("http.proxyPassword");
    }

    public int getHttpProxyPort() {
        String port = System.getProperty("http.proxyPort");
        if (Validator.isNull(port)) {
            return 0;
        }
        return Integer.parseInt(port);
    }

    public String getHttpProxyUser() {
        return System.getProperty("http.proxyUser");
    }

    public Path getMavenHomeDirPath() {
        return this._checkMavenHomeDirPath();
    }

    public Path getMavenLocalRepositoryDirPath() {
        String dirName = System.getProperty("maven.repo.local");
        if (Validator.isNull(dirName)) {
            return null;
        }
        return Paths.get(dirName, new String[0]);
    }

    public String getNexusPrivatePassword() {
        return System.getProperty("repository.private.password");
    }

    public String getNexusPrivateUserName() {
        return System.getProperty("repository.private.username");
    }

    public String getRepositoryUrl() {
        return System.getProperty("repository.url");
    }

    protected void after() {
        if (this._mavenHomeDirPath != null) {
            try {
                FileUtil.deleteDirectory(this._mavenHomeDirPath);
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
    }

    protected void before() throws Throwable {
        String mavenDistributionFileName = this.getMavenDistributionFileName();
        if (Validator.isNull(mavenDistributionFileName)) {
            throw new IllegalArgumentException("Please set the \"maven.distribution.file.name\" system property");
        }
        this._mavenHomeDirPath = Files.createTempDirectory("maven", new FileAttribute[0]);
        FileUtil.unzip(mavenDistributionFileName, this._mavenHomeDirPath, true);
        if (!this._isWindows()) {
            Set<PosixFilePermission> posixFilePermissions = PosixFilePermissions.fromString("rwxr-xr-x");
            Files.setPosixFilePermissions(this._mavenHomeDirPath.resolve("bin/mvn"), posixFilePermissions);
        }
    }

    protected String getMavenDistributionFileName() {
        return System.getProperty("maven.distribution.file.name");
    }

    protected String getMavenOpts() {
        return "-Dfile.encoding=UTF-8";
    }

    protected boolean isMavenDebug() {
        return Boolean.getBoolean("maven.debug");
    }

    protected void writeSettingsXmlFile() throws IOException {
        String repositoryUrl;
        boolean localRepository = false;
        boolean mirrors = false;
        boolean proxies = false;
        Path localRepositoryDirPath = this.getMavenLocalRepositoryDirPath();
        if (localRepositoryDirPath != null) {
            localRepository = true;
        }
        if (Validator.isNotNull(repositoryUrl = this.getRepositoryUrl())) {
            mirrors = true;
        }
        String httpProxyHost = this.getHttpProxyHost();
        int httpProxyPort = this.getHttpProxyPort();
        if (Validator.isNotNull(httpProxyHost) && httpProxyPort > 0) {
            proxies = true;
        }
        if (!(localRepository || mirrors || proxies)) {
            return;
        }
        String settingsXml = FileUtil.read(MavenExecutor.class, "dependencies/settings_xml.tmpl");
        settingsXml = localRepository ? settingsXml.replace("[$LOCAL_REPOSITORY_DIR$]", FileUtil.getAbsolutePath(localRepositoryDirPath)) : settingsXml.replaceFirst("<localRepository>[\\s\\S]+<\\/localRepository>", "");
        settingsXml = mirrors ? settingsXml.replace("[$REPOSITORY_URL$]", repositoryUrl) : settingsXml.replaceFirst("<mirrors>[\\s\\S]+<\\/mirrors>", "");
        if (proxies) {
            settingsXml = settingsXml.replace("[$HTTP_PROXY_HOST$]", httpProxyHost);
            settingsXml = settingsXml.replace("[$HTTP_PROXY_PORT$]", String.valueOf(httpProxyPort));
            settingsXml = this._replaceSettingsXmlElement(settingsXml, "[$HTTP_PROXY_USERNAME$]", this.getHttpProxyUser());
            settingsXml = this._replaceSettingsXmlElement(settingsXml, "[$HTTP_PROXY_PASSWORD$]", this.getHttpProxyPassword());
            settingsXml = this._replaceSettingsXmlElement(settingsXml, "[$HTTP_PROXY_NON_PROXY_HOSTS$]", this.getHttpNonProxyHosts());
        } else {
            settingsXml = settingsXml.replaceFirst("<proxies>[\\s\\S]+<\\/proxies>", "");
        }
        settingsXml = this._replaceSettingsXmlElement(settingsXml, "[$LIFERAY_NEXUS_PROFILE_ID$]", _LIFERAY_NEXUS_PROFILE_ID);
        settingsXml = this._replaceSettingsXmlElement(settingsXml, "[$XANADU_NEXUS_PROFILE_ID$]", _XANADU_NEXUS_PROFILE_ID);
        settingsXml = this._replaceSettingsXmlElement(settingsXml, "[$LIFERAY_NEXUS_REPO_ID$]", _LIFERAY_NEXUS_REPO_ID);
        settingsXml = this._replaceSettingsXmlElement(settingsXml, "[$XANADU_NEXUS_REPO_ID$]", _XANADU_NEXUS_REPO_ID);
        settingsXml = this._replaceSettingsXmlElement(settingsXml, "[$LIFERAY_NEXUS_REPO_URL$]", _LIFERAY_NEXUS_REPO_URL);
        settingsXml = this._replaceSettingsXmlElement(settingsXml, "[$XANADU_NEXUS_REPO_URL$]", _XANADU_NEXUS_REPO_URL);
        settingsXml = this._replaceSettingsXmlElement(settingsXml, "[$NEXUS_PRIVATE_USERNAME$]", this.getNexusPrivateUserName());
        settingsXml = this._replaceSettingsXmlElement(settingsXml, "[$NEXUS_PRIVATE_PASSWORD$]", this.getNexusPrivatePassword());
        Path settingsXmlPath = this._mavenHomeDirPath.resolve("conf/settings.xml");
        Files.write(settingsXmlPath, settingsXml.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private void _append(StringBuilder sb, InputStream inputStream) throws Exception {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (sb.length() > 0) {
                    sb.append(System.lineSeparator());
                }
                sb.append(line);
            }
        }
    }

    private Path _checkMavenHomeDirPath() {
        if (this._mavenHomeDirPath == null) {
            throw new IllegalStateException("The Maven home directory has not yet been created");
        }
        return this._mavenHomeDirPath;
    }

    private boolean _isWindows() {
        return File.pathSeparatorChar == ';';
    }

    private String _replaceSettingsXmlElement(String settingsXml, String placeholder, String value) {
        settingsXml = Validator.isNotNull(value) ? settingsXml.replace(placeholder, value) : settingsXml.replaceFirst("<\\w+>" + Pattern.quote(placeholder) + "<\\/\\w+>\\s+", "");
        return settingsXml;
    }

    public static class Result {
        public final int exitCode;
        public final String output;

        private Result(int exitCode, String output) {
            this.exitCode = exitCode;
            this.output = output;
        }
    }
}

