/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.marketplace.deployer;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.lpkg.deployer.LPKGDeployer;
import java.io.File;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class LPKGArtifactInstaller
implements ArtifactInstaller {
    private static final Log _log = LogFactoryUtil.getLog(LPKGArtifactInstaller.class);
    private BundleContext _bundleContext;
    @Reference
    private LPKGDeployer _lpkgDeployer;

    @Activate
    public void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    public boolean canHandle(File file) {
        String name = StringUtil.toLowerCase((String)file.getName());
        return name.endsWith(".lpkg");
    }

    public void install(File file) throws Exception {
        Properties properties = this._readMarketplaceProperties(file);
        if (GetterUtil.getBoolean((String)properties.getProperty("restart-required"), (boolean)true)) {
            return;
        }
        for (Bundle bundle : this._lpkgDeployer.deploy(this._bundleContext, file)) {
            Dictionary headers = bundle.getHeaders();
            String fragmentHost = (String)headers.get("Fragment-Host");
            if (fragmentHost != null) continue;
            try {
                bundle.start();
            }
            catch (BundleException be) {
                _log.error((Object)("Unable to start " + bundle + " for " + file), (Throwable)be);
            }
        }
    }

    public void uninstall(File file) throws Exception {
        Bundle bundle = this._bundleContext.getBundle(file.getCanonicalPath());
        if (bundle != null) {
            bundle.uninstall();
        }
    }

    public void update(File file) throws Exception {
        Properties properties = this._readMarketplaceProperties(file);
        if (GetterUtil.getBoolean((String)properties.getProperty("restart-required"), (boolean)true)) {
            return;
        }
        Bundle bundle = this._bundleContext.getBundle(file.getCanonicalPath());
        if (bundle != null) {
            Version currentVersion = bundle.getVersion();
            Version newVersion = new Version(properties.getProperty("version"));
            if (newVersion.compareTo(currentVersion) > 0) {
                bundle.update(this._lpkgDeployer.toBundle(file));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties _readMarketplaceProperties(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry zipEntry = zipFile.getEntry("liferay-marketplace.properties");
            if (zipEntry == null) {
                Properties properties2 = null;
                return properties2;
            }
            Properties properties3 = new Properties();
            try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                properties3.load(inputStream);
            }
            Properties properties = properties3;
            return properties;
        }
        catch (Exception e) {
            if (!_log.isDebugEnabled()) return null;
            _log.debug((Object)("Unable to read liferay-marketplace.properties from " + file.getName()), (Throwable)e);
            return null;
        }
    }
}

