/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.marketplace.app.manager.web.internal.util;

import com.liferay.marketplace.app.manager.web.internal.util.AppDisplay;
import com.liferay.marketplace.model.App;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import javax.portlet.MimeResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.Bundle;

public class MarketplaceAppManagerUtil {
    public static void addPortletBreadcrumbEntry(AppDisplay appDisplay, Bundle bundle, HttpServletRequest request, RenderResponse renderResponse) {
        PortletURL portletURL = renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/view.jsp");
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)LanguageUtil.get((HttpServletRequest)request, (String)"app-manager"), (String)portletURL.toString());
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)appDisplay.getDisplayTitle(), (String)appDisplay.getDisplayURL((MimeResponse)renderResponse));
        Dictionary headers = bundle.getHeaders("");
        String bundleName = GetterUtil.getString((String)((String)headers.get("Bundle-Name")));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)bundleName, null);
    }

    public static void addPortletBreadcrumbEntry(AppDisplay appDisplay, HttpServletRequest request, RenderResponse renderResponse) {
        PortletURL portletURL = renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/view.jsp");
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)LanguageUtil.get((HttpServletRequest)request, (String)"app-manager"), (String)portletURL.toString());
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)appDisplay.getDisplayTitle(), null);
    }

    public static String[] getCategories(List<App> apps, List<Bundle> bundles) {
        ArrayList<String> categories = new ArrayList<String>();
        categories.addAll(MarketplaceAppManagerUtil.getAppCategories(apps));
        categories.addAll(MarketplaceAppManagerUtil.getBundleCategories(bundles));
        ListUtil.distinct(categories);
        ListUtil.sort(categories);
        categories.add(0, "all-categories");
        return ArrayUtil.toStringArray(categories);
    }

    public static String getSearchContainerFieldText(Object object) {
        if (object == null) {
            return "";
        }
        String string = GetterUtil.getString((Object)object);
        string = StringUtil.shorten((String)string, (int)400);
        string = HtmlUtil.stripHtml((String)string);
        string = HtmlUtil.escape((String)string);
        return string;
    }

    protected static List<String> getAppCategories(List<App> apps) {
        ArrayList<String> categories = new ArrayList<String>(apps.size());
        for (App app : apps) {
            if (!Validator.isNotNull((String)app.getCategory())) continue;
            categories.add(app.getCategory());
        }
        return categories;
    }

    protected static List<String> getBundleCategories(List<Bundle> bundles) {
        ArrayList<String> categories = new ArrayList<String>();
        for (Bundle bundle : bundles) {
            String[] categoriesArray;
            Dictionary headers = bundle.getHeaders("");
            for (String category : categoriesArray = StringUtil.split((String)((String)headers.get("Liferay-Releng-Category")))) {
                if (!Validator.isNotNull((String)category)) continue;
                categories.add(category);
            }
        }
        return categories;
    }
}

