/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.marketplace.app.manager.web.internal.util;

import com.liferay.marketplace.app.manager.web.internal.util.AppDisplay;
import com.liferay.marketplace.app.manager.web.internal.util.AppDisplayFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;

public class MarketplaceAppManagerSearchUtil {
    public static List<Object> getResults(List<Bundle> bundles, String keywords) {
        ArrayList<Object> results = new ArrayList<Object>();
        String keywordsRegex = MarketplaceAppManagerSearchUtil.getKeywordsRegex(keywords);
        List<AppDisplay> appDisplays = AppDisplayFactoryUtil.getAppDisplays(bundles, "", 0);
        for (AppDisplay appDisplay : appDisplays) {
            if (!MarketplaceAppManagerSearchUtil.hasAppDisplayKeywordsMatch(appDisplay, keywordsRegex)) continue;
            results.add(appDisplay);
        }
        for (Bundle bundle : bundles) {
            if (!MarketplaceAppManagerSearchUtil.hasBundleKeywordsMatch(bundle, keywordsRegex)) continue;
            results.add(bundle);
        }
        return results;
    }

    protected static boolean containsMatches(String regex, String string) {
        if (string == null) {
            return false;
        }
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    protected static String getKeywordsRegex(String keywords) {
        keywords = StringUtil.replace((String)keywords, (char)' ', (char)'|');
        return "(" + keywords + ")";
    }

    protected static boolean hasAppDisplayKeywordsMatch(AppDisplay appDisplay, String keywordsRegex) {
        return MarketplaceAppManagerSearchUtil.containsMatches(keywordsRegex, appDisplay.getDisplayTitle()) || MarketplaceAppManagerSearchUtil.containsMatches(keywordsRegex, appDisplay.getDescription());
    }

    protected static boolean hasBundleKeywordsMatch(Bundle bundle, String keywordsRegex) {
        if (MarketplaceAppManagerSearchUtil.containsMatches(keywordsRegex, bundle.getSymbolicName())) {
            return true;
        }
        Dictionary headers = bundle.getHeaders("");
        String bundleDescription = (String)headers.get("Bundle-Description");
        if (MarketplaceAppManagerSearchUtil.containsMatches(keywordsRegex, bundleDescription)) {
            return true;
        }
        String bundleName = (String)headers.get("Bundle-Name");
        return MarketplaceAppManagerSearchUtil.containsMatches(keywordsRegex, bundleName);
    }
}

