/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.marketplace.app.manager.web.internal.util;

import com.liferay.marketplace.app.manager.web.internal.util.AppDisplay;
import com.liferay.marketplace.app.manager.web.internal.util.BundleUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.osgi.framework.Bundle;

public abstract class BaseAppDisplay
implements AppDisplay {
    private final List<Bundle> _bundles = new ArrayList<Bundle>();
    private String _suiteTitle;

    @Override
    public void addBundle(Bundle bundle) {
        this._bundles.add(bundle);
    }

    @Override
    public int compareTo(AppDisplay appDisplay) {
        if (appDisplay == null) {
            return -1;
        }
        String title = this.getTitle();
        return title.compareToIgnoreCase(appDisplay.getTitle());
    }

    @Override
    public List<Bundle> getBundles() {
        return this._bundles;
    }

    @Override
    public String getDisplaySuiteTitle() {
        if (this._suiteTitle != null) {
            return this._suiteTitle;
        }
        Bundle bundle = this._bundles.get(0);
        Dictionary headers = bundle.getHeaders("");
        this._suiteTitle = BaseAppDisplay.getDisplayTitle((String)headers.get("Liferay-Releng-Suite-Title"));
        return this._suiteTitle;
    }

    @Override
    public String getDisplayTitle() {
        return BaseAppDisplay.getDisplayTitle(this.getTitle());
    }

    @Override
    public int getState() {
        List<Bundle> bundles = this.getBundles();
        if (bundles.isEmpty()) {
            return 1;
        }
        int state = 32;
        for (Bundle bundle : bundles) {
            int bundleState;
            if (BundleUtil.isFragment(bundle) || state <= (bundleState = bundle.getState())) continue;
            state = bundleState;
        }
        return state;
    }

    protected static String getDisplayTitle(String title) {
        if (title == null) {
            return "";
        }
        if (!StringUtil.equals((String)ReleaseInfo.getName(), (String)"Liferay Community Edition Portal")) {
            return title.replaceFirst("^Liferay CE ", "Liferay ");
        }
        return title;
    }
}

