/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.marketplace.app.manager.web.internal.util;

import com.liferay.marketplace.app.manager.web.internal.util.AppDisplay;
import com.liferay.marketplace.app.manager.web.internal.util.BundlesMap;
import com.liferay.marketplace.app.manager.web.internal.util.MarketplaceAppDisplay;
import com.liferay.marketplace.app.manager.web.internal.util.SimpleAppDisplay;
import com.liferay.marketplace.model.App;
import com.liferay.marketplace.model.Module;
import com.liferay.marketplace.service.AppLocalService;
import com.liferay.marketplace.service.ModuleLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class AppDisplayFactoryUtil {
    private static final Log _log = LogFactoryUtil.getLog(AppDisplayFactoryUtil.class);
    private static AppLocalService _appLocalService;
    private static ModuleLocalService _moduleLocalService;

    public static AppDisplay getAppDisplay(List<Bundle> bundles, long appId) {
        try {
            BundlesMap bundlesMap = new BundlesMap(bundles.size());
            bundlesMap.load(bundles);
            App app = _appLocalService.getApp(appId);
            return AppDisplayFactoryUtil.createMarketplaceAppDisplay(bundlesMap, app);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return null;
        }
    }

    public static AppDisplay getAppDisplay(List<Bundle> bundles, String appTitle) {
        AppDisplay appDisplay = null;
        if (appTitle.equals("Independent Modules")) {
            appTitle = "";
        }
        for (Bundle bundle : bundles) {
            Dictionary headers = bundle.getHeaders("");
            String curAppTitle = GetterUtil.getString((String)((String)headers.get("Liferay-Releng-App-Title")));
            if (!appTitle.equals(curAppTitle)) continue;
            if (appDisplay == null) {
                String appDescription = GetterUtil.getString((String)((String)headers.get("Liferay-Releng-App-Description")));
                Version appVersion = bundle.getVersion();
                appDisplay = new SimpleAppDisplay(appTitle, appDescription, appVersion);
            }
            appDisplay.addBundle(bundle);
        }
        List<Bundle> appDisplayBundles = appDisplay.getBundles();
        if (appDisplayBundles.isEmpty()) {
            return null;
        }
        return appDisplay;
    }

    public static List<AppDisplay> getAppDisplays(List<Bundle> bundles, String category, int state) {
        ArrayList<AppDisplay> appDisplays = new ArrayList<AppDisplay>();
        BundlesMap bundlesMap = new BundlesMap(bundles.size());
        bundlesMap.load(bundles);
        appDisplays.addAll(AppDisplayFactoryUtil.createMarketplaceAppDisplays(bundlesMap, category));
        appDisplays.addAll(AppDisplayFactoryUtil.createPortalAppDisplays(bundlesMap, category));
        AppDisplayFactoryUtil.filterAppDisplays(appDisplays, state);
        return ListUtil.sort(appDisplays);
    }

    protected static AppDisplay createMarketplaceAppDisplay(BundlesMap bundlesMap, App app) {
        MarketplaceAppDisplay appDisplay = new MarketplaceAppDisplay(app);
        List modules = _moduleLocalService.getModules(app.getAppId());
        for (Module module : modules) {
            Bundle bundle = bundlesMap.getBundle(module);
            if (bundle == null) continue;
            appDisplay.addBundle(bundle);
        }
        return appDisplay;
    }

    protected static List<AppDisplay> createMarketplaceAppDisplays(BundlesMap bundlesMap, String category) {
        ArrayList<AppDisplay> appDisplays = new ArrayList<AppDisplay>();
        HashSet<Bundle> removeBundles = new HashSet<Bundle>();
        List apps = null;
        apps = Validator.isNotNull((String)category) ? _appLocalService.getApps(category) : _appLocalService.getApps(-1, -1);
        for (App app : apps) {
            AppDisplay appDisplay = AppDisplayFactoryUtil.createMarketplaceAppDisplay(bundlesMap, app);
            appDisplays.add(appDisplay);
            removeBundles.addAll(appDisplay.getBundles());
        }
        for (Bundle bundle : removeBundles) {
            bundlesMap.removeBundle(bundle);
        }
        return appDisplays;
    }

    protected static List<AppDisplay> createPortalAppDisplays(BundlesMap bundlesMap, String category) {
        HashMap<String, AppDisplay> appDisplaysMap = new HashMap<String, AppDisplay>();
        Collection bundles = bundlesMap.values();
        for (Bundle bundle : bundles) {
            Object[] categories;
            Dictionary headers = bundle.getHeaders("");
            if (Validator.isNotNull((String)category) && !ArrayUtil.contains((Object[])(categories = StringUtil.split((String)((String)headers.get("Liferay-Releng-Category")))), (Object)category)) continue;
            String appTitle = GetterUtil.getString((String)((String)headers.get("Liferay-Releng-App-Title")));
            AppDisplay appDisplay = (AppDisplay)appDisplaysMap.get(appTitle);
            if (appDisplay == null) {
                String appDescription = GetterUtil.getString((String)((String)headers.get("Liferay-Releng-App-Description")));
                Version appVersion = bundle.getVersion();
                appDisplay = new SimpleAppDisplay(appTitle, appDescription, appVersion);
                appDisplaysMap.put(appTitle, appDisplay);
            }
            appDisplay.addBundle(bundle);
        }
        return ListUtil.fromMapValues(appDisplaysMap);
    }

    protected static void filterAppDisplays(List<AppDisplay> appDisplays, int state) {
        Iterator<AppDisplay> iterator = appDisplays.iterator();
        while (iterator.hasNext()) {
            AppDisplay appDisplay = iterator.next();
            if (state <= 0 || appDisplay.getState() == state) continue;
            iterator.remove();
        }
    }

    @Reference(unbind="-")
    protected void setAppLocalService(AppLocalService appLocalService) {
        _appLocalService = appLocalService;
    }

    @Reference(unbind="-")
    protected void setModuleLocalService(ModuleLocalService moduleLocalService) {
        _moduleLocalService = moduleLocalService;
    }
}

