/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.marketplace.app.manager.web.internal.portlet;

import com.liferay.application.list.PanelAppRegistry;
import com.liferay.application.list.PanelCategoryRegistry;
import com.liferay.application.list.display.context.logic.PanelCategoryHelper;
import com.liferay.marketplace.app.manager.web.internal.util.BundleUtil;
import com.liferay.marketplace.bundle.BundleManager;
import com.liferay.marketplace.exception.FileExtensionException;
import com.liferay.marketplace.service.AppService;
import com.liferay.portal.bundle.blacklist.BundleBlacklistManager;
import com.liferay.portal.kernel.deploy.DeployManagerUtil;
import com.liferay.portal.kernel.model.PluginSetting;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.PluginSettingLocalService;
import com.liferay.portal.kernel.service.PluginSettingService;
import com.liferay.portal.kernel.service.PortletService;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.css-class-wrapper=marketplace-app-manager-portlet", "com.liferay.portlet.display-category=category.hidden", "com.liferay.portlet.header-portlet-css=/css/main.css", "com.liferay.portlet.icon=/icons/marketplace_app_manager.png", "com.liferay.portlet.preferences-owned-by-group=false", "com.liferay.portlet.private-request-attributes=false", "com.liferay.portlet.private-session-attributes=false", "com.liferay.portlet.render-weight=50", "com.liferay.portlet.use-default-template=true", "javax.portlet.description=", "javax.portlet.display-name=App Manager", "javax.portlet.init-param.template-path=/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_liferay_marketplace_app_manager_web_portlet_MarketplaceAppManagerPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator,guest,power-user,user", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class MarketplaceAppManagerPortlet
extends MVCPortlet {
    private AppService _appService;
    @Reference
    private BundleBlacklistManager _bundleBlacklistManager;
    @Reference
    private BundleManager _bundleManager;
    @Reference
    private Http _http;
    private PanelAppRegistry _panelAppRegistry;
    private PanelCategoryRegistry _panelCategoryRegistry;
    private PluginSettingLocalService _pluginSettingLocalService;
    private PluginSettingService _pluginSettingService;
    @Reference
    private Portal _portal;
    private PortletService _portletService;

    public void activateBundles(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long[] bundleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"bundleIds"), (long)0L);
        List bundles = this._bundleManager.getInstalledBundles();
        for (Bundle bundle : bundles) {
            if (BundleUtil.isFragment(bundle) || !ArrayUtil.contains((long[])bundleIds, (long)bundle.getBundleId())) continue;
            bundle.start();
        }
    }

    public void deactivateBundles(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long[] bundleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"bundleIds"), (long)0L);
        List bundles = this._bundleManager.getInstalledBundles();
        for (Bundle bundle : bundles) {
            if (BundleUtil.isFragment(bundle) || !ArrayUtil.contains((long[])bundleIds, (long)bundle.getBundleId())) continue;
            bundle.stop();
        }
    }

    public void installLocalApp(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        UploadPortletRequest uploadPortletRequest = this._portal.getUploadPortletRequest((PortletRequest)actionRequest);
        String fileName = GetterUtil.getString((String)uploadPortletRequest.getFileName("file"));
        File file = uploadPortletRequest.getFile("file");
        byte[] bytes = FileUtil.getBytes((File)file);
        if (ArrayUtil.isEmpty((byte[])bytes)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)UploadException.class.getName());
        } else {
            if (!(fileName.endsWith(".jar") || fileName.endsWith(".lpkg") || fileName.endsWith(".war"))) {
                throw new FileExtensionException();
            }
            String deployDir = PropsUtil.get((String)"auto.deploy.deploy.dir");
            FileUtil.copyFile((String)file.toString(), (String)(deployDir + "/" + fileName));
            SessionMessages.add((PortletRequest)actionRequest, (String)"pluginUploaded");
        }
        this.sendRedirect(actionRequest, actionResponse);
    }

    public void installRemoteApp(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            String url = ParamUtil.getString((PortletRequest)actionRequest, (String)"url");
            URL urlObj = new URL(url);
            String host = urlObj.getHost();
            if (host.endsWith("sf.net") || host.endsWith("sourceforge.net")) {
                this.doInstallSourceForgeApp(urlObj.getPath(), actionRequest);
            } else {
                this.doInstallRemoteApp(url, actionRequest, true);
            }
        }
        catch (MalformedURLException murle) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"invalidURL", (Object)murle);
        }
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        this.checkOmniAdmin();
        super.processAction(actionRequest, actionResponse);
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.checkOmniAdmin();
        super.render(renderRequest, renderResponse);
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        this.checkOmniAdmin();
        super.serveResource(resourceRequest, resourceResponse);
    }

    public void uninstallApp(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long remoteAppId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"remoteAppId");
        if (remoteAppId > 0L) {
            this._appService.uninstallApp(remoteAppId);
        } else {
            String[] contextNames;
            for (String contextName : contextNames = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"contextNames"))) {
                DeployManagerUtil.undeploy((String)contextName);
            }
        }
        SessionMessages.add((PortletRequest)actionRequest, (String)"triggeredPortletUndeploy");
    }

    public void uninstallBundles(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long[] bundleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"bundleIds"), (long)0L);
        List bundles = this._bundleManager.getInstalledBundles();
        ArrayList<String> symbolicNames = new ArrayList<String>(bundleIds.length);
        for (Bundle bundle : bundles) {
            if (!ArrayUtil.contains((long[])bundleIds, (long)bundle.getBundleId())) continue;
            symbolicNames.add(bundle.getSymbolicName());
        }
        this._bundleBlacklistManager.addToBlacklistAndUninstall(symbolicNames.toArray(new String[symbolicNames.size()]));
    }

    public void updatePluginSetting(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String pluginId = ParamUtil.getString((PortletRequest)actionRequest, (String)"pluginId");
        String pluginType = ParamUtil.getString((PortletRequest)actionRequest, (String)"pluginType");
        Object[] roles = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"roles"), (char)'\n');
        Arrays.sort(roles);
        boolean active = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"active");
        if (pluginType.equals("portlet")) {
            this._portletService.updatePortlet(themeDisplay.getCompanyId(), pluginId, "", active);
        } else {
            if (roles.length == 0) {
                PluginSetting pluginSetting = this._pluginSettingLocalService.getPluginSetting(themeDisplay.getCompanyId(), pluginId, pluginType);
                roles = StringUtil.split((String)pluginSetting.getRoles());
            }
            this._pluginSettingService.updatePluginSetting(themeDisplay.getCompanyId(), pluginId, pluginType, StringUtil.merge((Object[])roles), active);
        }
    }

    public void updatePluginSettings(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String[] contextNames = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"contextNames"));
        boolean active = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"active");
        for (String contextName : contextNames) {
            List themes;
            List portlets;
            ServletContext servletContext = ServletContextPool.get((String)contextName);
            List layoutTemplates = (List)servletContext.getAttribute("PLUGIN_LAYOUT_TEMPLATES");
            if (layoutTemplates != null) {
                for (Object layoutTemplate : layoutTemplates) {
                    PluginSetting pluginSetting = this._pluginSettingLocalService.getPluginSetting(themeDisplay.getCompanyId(), layoutTemplate.getLayoutTemplateId(), "layouttpl");
                    this._pluginSettingService.updatePluginSetting(themeDisplay.getCompanyId(), layoutTemplate.getLayoutTemplateId(), "layouttpl", pluginSetting.getRoles(), active);
                }
            }
            if ((portlets = (List)servletContext.getAttribute("PLUGIN_PORTLETS")) != null) {
                Object layoutTemplate;
                layoutTemplate = portlets.iterator();
                while (layoutTemplate.hasNext()) {
                    com.liferay.portal.kernel.model.Portlet portlet = (com.liferay.portal.kernel.model.Portlet)layoutTemplate.next();
                    this._portletService.updatePortlet(themeDisplay.getCompanyId(), portlet.getPortletId(), "", active);
                }
            }
            if ((themes = (List)servletContext.getAttribute("PLUGIN_THEMES")) == null) continue;
            for (Theme theme : themes) {
                PluginSetting pluginSetting = this._pluginSettingLocalService.getPluginSetting(themeDisplay.getCompanyId(), theme.getThemeId(), "theme");
                this._pluginSettingService.updatePluginSetting(themeDisplay.getCompanyId(), theme.getThemeId(), "theme", pluginSetting.getRoles(), active);
            }
        }
    }

    protected void checkOmniAdmin() throws PortletException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (!permissionChecker.isOmniadmin()) {
            PrincipalException.MustBeCompanyAdmin principalException = new PrincipalException.MustBeCompanyAdmin(permissionChecker.getUserId());
            throw new PortletException((Throwable)principalException);
        }
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        renderRequest.setAttribute("PANEL_APP_REGISTRY", (Object)this._panelAppRegistry);
        PanelCategoryHelper panelCategoryHelper = new PanelCategoryHelper(this._panelAppRegistry, this._panelCategoryRegistry);
        renderRequest.setAttribute("PANEL_CATEGORY_HELPER", (Object)panelCategoryHelper);
        renderRequest.setAttribute("PANEL_CATEGORY_REGISTRY", (Object)this._panelCategoryRegistry);
        super.doDispatch(renderRequest, renderResponse);
    }

    protected int doInstallRemoteApp(String url, ActionRequest actionRequest, boolean failOnError) throws Exception {
        int responseCode = 200;
        try {
            Http.Options options = new Http.Options();
            options.setFollowRedirects(false);
            options.setLocation(url);
            options.setPost(false);
            byte[] bytes = this._http.URLtoByteArray(options);
            Http.Response response = options.getResponse();
            responseCode = response.getResponseCode();
            if (responseCode == 200 && bytes.length > 0) {
                String deployDir = PropsUtil.get((String)"auto.deploy.deploy.dir");
                String destination = deployDir + "/" + url.substring(url.lastIndexOf(47) + 1);
                File destinationFile = new File(destination);
                FileUtil.write((File)destinationFile, (byte[])bytes);
                SessionMessages.add((PortletRequest)actionRequest, (String)"pluginDownloaded");
            } else {
                if (failOnError) {
                    SessionErrors.add((PortletRequest)actionRequest, (String)UploadException.class.getName());
                }
                responseCode = 500;
            }
        }
        catch (MalformedURLException murle) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"invalidUrl", (Object)murle);
        }
        catch (IOException ioe) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"errorConnectingToUrl", (Object)ioe);
        }
        return responseCode;
    }

    protected void doInstallSourceForgeApp(String path, ActionRequest actionRequest) throws Exception {
        String[] sourceForgeMirrors = PropsUtil.getArray((String)"source.forge.mirrors");
        for (int i = 0; i < sourceForgeMirrors.length; ++i) {
            try {
                int responseCode;
                String url = sourceForgeMirrors[i] + path;
                boolean failOnError = false;
                if (i + 1 == sourceForgeMirrors.length) {
                    failOnError = true;
                }
                if ((responseCode = this.doInstallRemoteApp(url, actionRequest, failOnError)) != 200) continue;
                return;
            }
            catch (MalformedURLException murle) {
                SessionErrors.add((PortletRequest)actionRequest, (String)"invalidUrl", (Object)murle);
            }
        }
    }

    @Reference(unbind="-")
    protected void setAppService(AppService appService) {
        this._appService = appService;
    }

    @Reference(unbind="-")
    protected void setPanelAppRegistry(PanelAppRegistry panelAppRegistry) {
        this._panelAppRegistry = panelAppRegistry;
    }

    @Reference(unbind="-")
    protected void setPanelCategoryRegistry(PanelCategoryRegistry panelCategoryRegistry) {
        this._panelCategoryRegistry = panelCategoryRegistry;
    }

    @Reference(unbind="-")
    protected void setPluginSettingLocalService(PluginSettingLocalService pluginSettingLocalService) {
        this._pluginSettingLocalService = pluginSettingLocalService;
    }

    @Reference(unbind="-")
    protected void setPluginSettingService(PluginSettingService pluginSettingService) {
        this._pluginSettingService = pluginSettingService;
    }

    @Reference(unbind="-")
    protected void setPortletService(PortletService portletService) {
        this._portletService = portletService;
    }
}

