/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.marketplace.app.manager.web.internal.display.context;

import com.liferay.marketplace.app.manager.web.internal.display.context.BaseAppManagerManagementToolbarDisplayContext;
import com.liferay.marketplace.app.manager.web.internal.util.AppDisplay;
import com.liferay.marketplace.app.manager.web.internal.util.AppDisplayFactoryUtil;
import com.liferay.marketplace.app.manager.web.internal.util.BundleManagerUtil;
import com.liferay.marketplace.app.manager.web.internal.util.comparator.ModuleServiceReferenceComparator;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.portlet.Portlet;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ViewModuleManagementToolbarDisplayContext
extends BaseAppManagerManagementToolbarDisplayContext {
    private SearchContainer _searchContainer;

    public ViewModuleManagementToolbarDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, HttpServletRequest request) {
        super(liferayPortletRequest, liferayPortletResponse, request);
    }

    public String getApp() {
        return ParamUtil.getString((HttpServletRequest)this.request, (String)"app");
    }

    public AppDisplay getAppDisplay() {
        String app = ParamUtil.getString((HttpServletRequest)this.request, (String)"app");
        AppDisplay appDisplay = null;
        List<Bundle> allBundles = BundleManagerUtil.getBundles();
        if (Validator.isNumber((String)app)) {
            appDisplay = AppDisplayFactoryUtil.getAppDisplay(allBundles, GetterUtil.getLong((String)app));
        }
        if (appDisplay == null) {
            appDisplay = AppDisplayFactoryUtil.getAppDisplay(allBundles, app);
        }
        return appDisplay;
    }

    public Bundle getBundle() {
        String symbolicName = ParamUtil.getString((HttpServletRequest)this.request, (String)"symbolicName");
        String version = ParamUtil.getString((HttpServletRequest)this.request, (String)"version");
        return BundleManagerUtil.getBundle(symbolicName, version);
    }

    public String getPluginType() {
        return ParamUtil.getString((HttpServletRequest)this.request, (String)"pluginType", (String)"components");
    }

    @Override
    public PortletURL getPortletURL() {
        PortletURL portletURL = this.liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/view_module.jsp");
        portletURL.setParameter("app", this.getApp());
        Bundle bundle = this.getBundle();
        portletURL.setParameter("symbolicName", bundle.getSymbolicName());
        portletURL.setParameter("version", String.valueOf(bundle.getVersion()));
        portletURL.setParameter("pluginType", this.getPluginType());
        portletURL.setParameter("orderByType", this.getOrderByType());
        if (this._searchContainer != null) {
            portletURL.setParameter(this._searchContainer.getCurParam(), String.valueOf(this._searchContainer.getCur()));
            portletURL.setParameter(this._searchContainer.getDeltaParam(), String.valueOf(this._searchContainer.getDelta()));
        }
        return portletURL;
    }

    @Override
    public SearchContainer getSearchContainer() throws Exception {
        if (this._searchContainer != null) {
            return this._searchContainer;
        }
        String emptyResultsMessage = "no-portlets-were-found";
        String pluginType = this.getPluginType();
        if (pluginType.equals("components")) {
            emptyResultsMessage = "no-components-were-found";
        }
        SearchContainer searchContainer = new SearchContainer((PortletRequest)this.liferayPortletRequest, this.getPortletURL(), null, emptyResultsMessage);
        searchContainer.setOrderByCol(this.getOrderByCol());
        searchContainer.setOrderByType(this.getOrderByType());
        Bundle bundle = this.getBundle();
        BundleContext bundleContext = bundle.getBundleContext();
        List serviceReferences = Collections.emptyList();
        if (pluginType.equals("portlets")) {
            Collection serviceReferenceCollection = bundleContext.getServiceReferences(Portlet.class, "(service.bundleid=" + bundle.getBundleId() + ")");
            serviceReferences = new ArrayList(serviceReferenceCollection);
            serviceReferences = ListUtil.sort((List)serviceReferences, new ModuleServiceReferenceComparator("javax.portlet.display-name", this.getOrderByType()));
        } else {
            Object[] serviceReferenceArray = bundleContext.getServiceReferences((String)null, "(&(component.id=*)(service.bundleid=" + bundle.getBundleId() + "))");
            serviceReferences = ListUtil.toList((Object[])serviceReferenceArray);
            serviceReferences = ListUtil.sort((List)serviceReferences, new ModuleServiceReferenceComparator("component.name", this.getOrderByType()));
        }
        int end = searchContainer.getEnd();
        if (end > serviceReferences.size()) {
            end = serviceReferences.size();
        }
        searchContainer.setResults(serviceReferences.subList(searchContainer.getStart(), end));
        searchContainer.setTotal(serviceReferences.size());
        this._searchContainer = searchContainer;
        return this._searchContainer;
    }
}

