/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.marketplace.app.manager.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItemList;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.List;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class AppManagerDisplayContext {
    private final RenderResponse _renderResponse;
    private final HttpServletRequest _request;

    public AppManagerDisplayContext(HttpServletRequest request, RenderResponse renderResponse) {
        this._request = request;
        this._renderResponse = renderResponse;
    }

    public List<NavigationItem> getModuleNavigationItems() {
        final String pluginType = ParamUtil.getString((HttpServletRequest)this._request, (String)"pluginType", (String)"components");
        return new NavigationItemList(){
            {
                this.add(navigationItem -> {
                    navigationItem.setActive(pluginType.equals("components"));
                    navigationItem.setHref((Object)AppManagerDisplayContext.this._getViewModuleURL("components"));
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)AppManagerDisplayContext.this._request, (String)"components"));
                });
                this.add(navigationItem -> {
                    navigationItem.setActive(pluginType.equals("portlets"));
                    navigationItem.setHref((Object)AppManagerDisplayContext.this._getViewModuleURL("portlets"));
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)AppManagerDisplayContext.this._request, (String)"portlets"));
                });
            }
        };
    }

    public List<NavigationItem> getNavigationItems(final String url, final String label) {
        return new NavigationItemList(){
            {
                this.add(navigationItem -> {
                    navigationItem.setActive(true);
                    navigationItem.setHref((Object)url);
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)AppManagerDisplayContext.this._request, (String)label));
                });
            }
        };
    }

    private String _getViewModuleURL(String pluginType) {
        String app = ParamUtil.getString((HttpServletRequest)this._request, (String)"app");
        String moduleGroup = ParamUtil.getString((HttpServletRequest)this._request, (String)"moduleGroup");
        String symbolicName = ParamUtil.getString((HttpServletRequest)this._request, (String)"symbolicName");
        String version = ParamUtil.getString((HttpServletRequest)this._request, (String)"version");
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/view_module.jsp");
        portletURL.setParameter("app", app);
        portletURL.setParameter("moduleGroup", moduleGroup);
        portletURL.setParameter("symbolicName", symbolicName);
        portletURL.setParameter("version", version);
        portletURL.setParameter("pluginType", pluginType);
        return portletURL.toString();
    }
}

