/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.web.util;

import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.mail.reader.attachment.AttachmentHandler;
import com.liferay.mail.reader.exception.MailException;
import com.liferay.mail.reader.mailbox.Mailbox;
import com.liferay.mail.reader.mailbox.MailboxFactoryUtil;
import com.liferay.mail.reader.mailbox.PasswordRetriever;
import com.liferay.mail.reader.model.Account;
import com.liferay.mail.reader.model.Attachment;
import com.liferay.mail.reader.model.Folder;
import com.liferay.mail.reader.model.MailFile;
import com.liferay.mail.reader.model.MessageDisplay;
import com.liferay.mail.reader.model.MessagesDisplay;
import com.liferay.mail.reader.service.AccountLocalServiceUtil;
import com.liferay.mail.reader.service.AttachmentLocalServiceUtil;
import com.liferay.mail.reader.service.FolderLocalServiceUtil;
import com.liferay.mail.reader.service.MessageLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.portlet.PortletConfig;
import javax.servlet.http.HttpServletRequest;

public class MailManager {
    private static final Log _log = LogFactoryUtil.getLog(MailManager.class);
    private final PasswordRetriever _passwordRetriever;
    private final PortletConfig _portletConfig;
    private final User _user;

    public static MailManager getInstance(HttpServletRequest request) throws PortalException {
        User user = PortalUtil.getUser((HttpServletRequest)request);
        if (user == null) {
            return null;
        }
        PortletConfig portletConfig = (PortletConfig)request.getAttribute("javax.portlet.config");
        return new MailManager(user, new PasswordRetriever(request), portletConfig);
    }

    public MailManager(User user, PasswordRetriever passwordRetriever, PortletConfig portletConfig) {
        this._user = user;
        this._passwordRetriever = passwordRetriever;
        this._portletConfig = portletConfig;
    }

    public JSONObject addAccount(String address, String personalName, String protocol, String incomingHostName, int incomingPort, boolean incomingSecure, String outgoingHostName, int outgoingPort, boolean outgoingSecure, String login, String password, boolean savePassword, String signature, boolean useSignature, String folderPrefix, boolean defaultSender) throws PortalException {
        try {
            Mailbox mailbox = MailboxFactoryUtil.getMailbox((long)this._user.getUserId(), (String)protocol);
            Account account = mailbox.addAccount(address, personalName, protocol, incomingHostName, incomingPort, incomingSecure, outgoingHostName, outgoingPort, outgoingSecure, login, password, savePassword, signature, useSignature, folderPrefix, defaultSender);
            if (!savePassword) {
                this._passwordRetriever.setPassword(account.getAccountId(), password);
            }
            mailbox = MailboxFactoryUtil.getMailbox((long)this._user.getUserId(), (long)account.getAccountId(), (String)this._passwordRetriever.getPassword(account.getAccountId()));
            mailbox.updateFolders();
            this.synchronizeAccount(account.getAccountId());
            return this.createJSONResult("success", "account-has-been-created");
        }
        catch (MailException me) {
            if (me.getType() == 1) {
                return this.createJSONResult("failure", "an-account-with-the-same-address-already-exists");
            }
            _log.error((Object)me, (Throwable)me);
            return this.createJSONResult("failure", "unable-to-add-account");
        }
    }

    public com.liferay.mail.reader.model.Message addDraft(long accountId) throws PortalException {
        Account account = AccountLocalServiceUtil.getAccount((long)accountId);
        com.liferay.mail.reader.model.Message message = MessageLocalServiceUtil.addMessage((long)this._user.getUserId(), (long)account.getDraftFolderId(), (String)account.getAddress(), (String)"", (String)"", (String)"", (Date)new Date(), (String)"", (String)"", (String)"", (long)0L, (String)"text/html; charset=UTF-8");
        return message;
    }

    public JSONObject addFolder(long accountId, String displayName) throws PortalException {
        try {
            Mailbox mailbox = MailboxFactoryUtil.getMailbox((long)this._user.getUserId(), (long)accountId, (String)this._passwordRetriever.getPassword(accountId));
            mailbox.addFolder(displayName);
            return this.createJSONResult("success", "folder-has-been-created");
        }
        catch (MailException me) {
            if (me.getType() == 5) {
                return this.createJSONResult("failure", "a-folder-with-the-same-name-already-exists");
            }
            _log.error((Object)me, (Throwable)me);
            return this.createJSONResult("failure", "unable-to-create-folder");
        }
    }

    public JSONObject checkMessages(long accountId, long folderId) throws PortalException {
        try {
            Mailbox mailbox = MailboxFactoryUtil.getMailbox((long)this._user.getUserId(), (long)accountId, (String)this._passwordRetriever.getPassword(accountId));
            if (mailbox.hasNewMessages(folderId)) {
                mailbox.synchronizeFolder(folderId);
                return this.createJSONResult("success", "", "true");
            }
            return this.createJSONResult("success", "", "false");
        }
        catch (MailException me) {
            return this.createJSONResult("failure", "");
        }
    }

    public JSONObject deleteAccount(long accountId) throws PortalException {
        try {
            Mailbox mailbox = MailboxFactoryUtil.getMailbox((long)this._user.getUserId(), (long)accountId, (String)this._passwordRetriever.getPassword(accountId));
            this._passwordRetriever.removePassword(accountId);
            mailbox.deleteAccount();
            return this.createJSONResult("success", "account-has-been-deleted");
        }
        catch (MailException me) {
            _log.error((Object)me, (Throwable)me);
            return this.createJSONResult("failure", "unable-to-delete-account");
        }
    }

    public JSONObject deleteAttachment(long attachmentId) throws PortalException {
        try {
            Attachment attachment = AttachmentLocalServiceUtil.getAttachment((long)attachmentId);
            Mailbox mailbox = MailboxFactoryUtil.getMailbox((long)this._user.getUserId(), (long)attachment.getAccountId(), (String)this._passwordRetriever.getPassword(attachment.getAccountId()));
            mailbox.deleteAttachment(attachmentId);
            return this.createJSONResult("success", "attachment-has-been-deleted");
        }
        catch (MailException me) {
            _log.error((Object)me, (Throwable)me);
            return this.createJSONResult("failure", "unable-to-delete-attachment");
        }
    }

    public JSONObject deleteFolder(long folderId) throws PortalException {
        try {
            Folder folder = FolderLocalServiceUtil.getFolder((long)folderId);
            Mailbox mailbox = MailboxFactoryUtil.getMailbox((long)this._user.getUserId(), (long)folder.getAccountId(), (String)this._passwordRetriever.getPassword(folder.getAccountId()));
            mailbox.deleteFolder(folderId);
            return this.createJSONResult("success", "folder-has-been-deleted");
        }
        catch (MailException me) {
            if (me.getType() == 12) {
                return this.createJSONResult("failure", "this-is-a-required-folder-and-can-not-be-deleted");
            }
            if (me.getType() == 7) {
                return this.createJSONResult("failure", "the-mail-server-will-not-allow-this-folder-to-be-deleted");
            }
            _log.error((Object)me, (Throwable)me);
            return this.createJSONResult("failure", "unable-to-delete-folder");
        }
    }

    public JSONObject deleteMessages(long[] messageIds) throws PortalException {
        try {
            if (messageIds.length == 0) {
                return this.createJSONResult("failure", "no-messages-selected");
            }
            com.liferay.mail.reader.model.Message message = MessageLocalServiceUtil.getMessage((long)messageIds[0]);
            Account account = AccountLocalServiceUtil.getAccount((long)message.getAccountId());
            if (account.getDraftFolderId() == message.getFolderId()) {
                for (long messageId : messageIds) {
                    MessageLocalServiceUtil.deleteMessage((long)messageId);
                }
                return this.createJSONResult("success", "drafts-have-been-discarded");
            }
            Mailbox mailbox = MailboxFactoryUtil.getMailbox((long)this._user.getUserId(), (long)message.getAccountId(), (String)this._passwordRetriever.getPassword(message.getAccountId()));
            mailbox.deleteMessages(message.getFolderId(), messageIds);
            return this.createJSONResult("success", "messages-have-been-deleted");
        }
        catch (MailException me) {
            _log.error((Object)me, (Throwable)me);
            return this.createJSONResult("failure", "unable-to-delete-messages");
        }
    }

    public JSONObject flagMessages(long[] messageIds, int flag, boolean value) throws PortalException {
        try {
            if (messageIds.length == 0) {
                return this.createJSONResult("failure", "no-messages-selected");
            }
            com.liferay.mail.reader.model.Message message = MessageLocalServiceUtil.getMessage((long)messageIds[0]);
            Mailbox mailbox = MailboxFactoryUtil.getMailbox((long)this._user.getUserId(), (long)message.getAccountId(), (String)this._passwordRetriever.getPassword(message.getAccountId()));
            mailbox.updateFlags(message.getFolderId(), messageIds, flag, value);
            return this.createJSONResult("success", "messages-have-been-flagged");
        }
        catch (MailException me) {
            if (me.getType() == 15) {
                return this.createJSONResult("failure", "this-flag-is-not-supported");
            }
            _log.error((Object)me, (Throwable)me);
            return this.createJSONResult("failure", "unable-to-flag-messages");
        }
    }

    public List<Account> getAccounts() {
        return AccountLocalServiceUtil.getAccounts((long)this._user.getUserId());
    }

    public long getAccountUnreadMessagesCount(long accountId) {
        return MessageLocalServiceUtil.getAccountUnreadMessagesCount((long)accountId);
    }

    public AttachmentHandler getAttachment(long attachmentId) throws IOException, PortalException {
        Attachment attachment = AttachmentLocalServiceUtil.getAttachment((long)attachmentId);
        Mailbox mailbox = MailboxFactoryUtil.getMailbox((long)this._user.getUserId(), (long)attachment.getAccountId(), (String)this._passwordRetriever.getPassword(attachment.getAccountId()));
        return mailbox.getAttachment(attachmentId);
    }

    public JSONObject getDefaultAccountsJSONObject() {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        JSONObject gmailAccountJSONObject = JSONFactoryUtil.createJSONObject();
        gmailAccountJSONObject.put("address", "@gmail.com");
        gmailAccountJSONObject.put("descriptionLanguageKey", "please-enable-imap-in-you-gmail-settings-for-mail-to-work");
        gmailAccountJSONObject.put("folderPrefix", "");
        gmailAccountJSONObject.put("hideSettings", true);
        gmailAccountJSONObject.put("incomingHostName", "imap.gmail.com");
        gmailAccountJSONObject.put("incomingPort", 993);
        gmailAccountJSONObject.put("incomingSecure", true);
        gmailAccountJSONObject.put("outgoingHostName", "smtp.gmail.com");
        gmailAccountJSONObject.put("outgoingPort", 465);
        gmailAccountJSONObject.put("outgoingSecure", true);
        gmailAccountJSONObject.put("protocol", "imap");
        gmailAccountJSONObject.put("titleLanguageKey", "gmail-account");
        gmailAccountJSONObject.put("useLocalPartAsLogin", true);
        jsonArray.put(gmailAccountJSONObject);
        JSONObject customMailAccontJSONObject = JSONFactoryUtil.createJSONObject();
        customMailAccontJSONObject.put("address", "");
        customMailAccontJSONObject.put("descriptionLanguageKey", "");
        customMailAccontJSONObject.put("folderPrefix", "");
        customMailAccontJSONObject.put("hideSettings", false);
        customMailAccontJSONObject.put("incomingHostName", "");
        customMailAccontJSONObject.put("incomingPort", 110);
        customMailAccontJSONObject.put("incomingSecure", false);
        customMailAccontJSONObject.put("outgoingHostName", "");
        customMailAccontJSONObject.put("outgoingPort", 25);
        customMailAccontJSONObject.put("outgoingSecure", false);
        customMailAccontJSONObject.put("protocol", "imap");
        customMailAccontJSONObject.put("titleLanguageKey", "custom-mail-account");
        customMailAccontJSONObject.put("useLocalPartAsLogin", false);
        jsonArray.put(customMailAccontJSONObject);
        jsonObject.put("accounts", jsonArray);
        return jsonObject;
    }

    public List<Folder> getFolders(long accountId, boolean includeRequiredFolders, boolean includeNonRequiredFolders) throws PortalException {
        List folders = FolderLocalServiceUtil.getFolders((long)accountId);
        ArrayList<Folder> requiredFolders = new ArrayList<Folder>();
        ArrayList<Folder> nonRequiredFolders = new ArrayList<Folder>();
        Account account = AccountLocalServiceUtil.getAccount((long)accountId);
        for (Folder folder : folders) {
            if (folder.getFolderId() == account.getInboxFolderId() || folder.getFolderId() == account.getDraftFolderId() || folder.getFolderId() == account.getSentFolderId() || folder.getFolderId() == account.getTrashFolderId()) {
                requiredFolders.add(folder);
                continue;
            }
            nonRequiredFolders.add(folder);
        }
        if (includeRequiredFolders && includeNonRequiredFolders) {
            requiredFolders.addAll(nonRequiredFolders);
            return requiredFolders;
        }
        if (includeNonRequiredFolders) {
            return nonRequiredFolders;
        }
        return requiredFolders;
    }

    public long getFolderUnreadMessagesCount(long folderId) {
        return MessageLocalServiceUtil.getFolderUnreadMessagesCount((long)folderId);
    }

    public Account getInitialAccount() {
        List accounts = AccountLocalServiceUtil.getAccounts((long)this._user.getUserId());
        if (accounts.isEmpty()) {
            return null;
        }
        return (Account)accounts.get(0);
    }

    public MessageDisplay getMessageDisplay(long messageId) throws PortalException {
        com.liferay.mail.reader.model.Message message = MessageLocalServiceUtil.getMessage((long)messageId);
        if (Validator.isNull((String)message.getBody())) {
            Mailbox mailbox = MailboxFactoryUtil.getMailbox((long)this._user.getUserId(), (long)message.getAccountId(), (String)this._passwordRetriever.getPassword(message.getAccountId()));
            mailbox.synchronizeMessage(message.getMessageId());
            message = MessageLocalServiceUtil.getMessage((long)messageId);
        }
        List attachments = AttachmentLocalServiceUtil.getAttachments((long)messageId);
        return new MessageDisplay(message, attachments, 0);
    }

    public MessageDisplay getMessageDisplay(long folderId, int messageNumber, String orderByField, String orderByType, String keywords) throws PortalException {
        if (folderId <= 0L) {
            return null;
        }
        MessagesDisplay messagesDisplay = this.getMessagesDisplay(folderId, messageNumber, 1, orderByField, orderByType, keywords);
        List messages = messagesDisplay.getMessages();
        com.liferay.mail.reader.model.Message message = (com.liferay.mail.reader.model.Message)messages.get(0);
        List attachments = AttachmentLocalServiceUtil.getAttachments((long)message.getMessageId());
        return new MessageDisplay(message, attachments, messagesDisplay.getMessageCount());
    }

    public MessagesDisplay getMessagesDisplay(long folderId, int pageNumber, int messagesPerPage, String orderByField, String orderByType, String keywords) throws PortalException {
        Folder folder = FolderLocalServiceUtil.getFolder((long)folderId);
        if (folderId != 0L) {
            Mailbox mailbox = MailboxFactoryUtil.getMailbox((long)this._user.getUserId(), (long)folder.getAccountId(), (String)this._passwordRetriever.getPassword(folder.getAccountId()));
            return mailbox.getMessagesDisplay(folderId, keywords, pageNumber, messagesPerPage, orderByField, orderByType);
        }
        return new MessagesDisplay(new ArrayList(), pageNumber, messagesPerPage, 0);
    }

    public String getPassword(long accountId) throws PortalException {
        return this._passwordRetriever.getPassword(accountId);
    }

    public void markAsRead(long accountId, long folderId, long messageId) throws PortalException {
        Message message = new Message();
        message.put("command", (Object)"flag");
        message.put("userId", (Object)this._user.getUserId());
        message.put("accountId", (Object)accountId);
        message.put("password", (Object)this._passwordRetriever.getPassword(accountId));
        message.put("folderId", (Object)folderId);
        message.put("messageId", (Object)messageId);
        message.put("flag", (Object)6);
        message.put("flagValue", (Object)true);
        MessageBusUtil.sendMessage((String)"liferay/mail_synchronizer", (Message)message);
    }

    public JSONObject moveMessages(long folderId, long[] messageIds) throws PortalException {
        try {
            if (messageIds.length == 0) {
                return this.createJSONResult("failure", "no-messages-selected");
            }
            Folder folder = FolderLocalServiceUtil.getFolder((long)folderId);
            Account account = AccountLocalServiceUtil.getAccount((long)folder.getAccountId());
            if (account.getDraftFolderId() == folderId || account.getSentFolderId() == folderId) {
                throw new MailException(9);
            }
            com.liferay.mail.reader.model.Message message = MessageLocalServiceUtil.getMessage((long)messageIds[0]);
            Mailbox mailbox = MailboxFactoryUtil.getMailbox((long)this._user.getUserId(), (long)message.getAccountId(), (String)this._passwordRetriever.getPassword(message.getAccountId()));
            mailbox.moveMessages(folderId, messageIds);
            return this.createJSONResult("success", "messages-have-been-moved");
        }
        catch (MailException me) {
            if (me.getType() == 9) {
                return this.createJSONResult("failure", "cannot-move-messages-to-this-folder");
            }
            _log.error((Object)me, (Throwable)me);
            return this.createJSONResult("failure", "unable-to-move-messages");
        }
    }

    public JSONObject renameFolder(long folderId, String displayName) throws PortalException {
        Folder folder = FolderLocalServiceUtil.getFolder((long)folderId);
        try {
            Mailbox mailbox = MailboxFactoryUtil.getMailbox((long)this._user.getUserId(), (long)folder.getAccountId(), (String)this._passwordRetriever.getPassword(folder.getAccountId()));
            mailbox.renameFolder(folderId, displayName);
            return this.createJSONResult("success", "folder-renamed-successfully");
        }
        catch (MailException me) {
            if (me.getType() == 11) {
                return this.createJSONResult("failure", "cannot-move-messages-to-this-folder");
            }
            if (me.getType() == 5) {
                return this.createJSONResult("failure", "a-folder-with-the-same-name-already-exists");
            }
            _log.error((Object)me, (Throwable)me);
            return this.createJSONResult("failure", "unable-to-rename-folder");
        }
    }

    public JSONObject saveDraft(long accountId, long messageId, String to, String cc, String bcc, String subject, String body, List<MailFile> mailFiles) throws PortalException {
        try {
            Mailbox mailbox = MailboxFactoryUtil.getMailbox((long)this._user.getUserId(), (long)accountId, (String)this._passwordRetriever.getPassword(accountId));
            com.liferay.mail.reader.model.Message message = mailbox.saveDraft(accountId, messageId, to, cc, bcc, subject, body, mailFiles);
            return this.createJSONResult("success", "saved-successfully", String.valueOf(message.getMessageId()));
        }
        catch (MailException me) {
            if (me.getType() == 13) {
                return this.createJSONResult("failure", "please-specify-at-least-one-recipient");
            }
            if (me.getType() == 14) {
                return this.createJSONResult("failure", "please-make-sure-the-following-address-is-properly-formatted", me.getValue());
            }
            _log.error((Object)me, (Throwable)me);
            return this.createJSONResult("failure", "unable-to-save-draft");
        }
    }

    public JSONObject sendMessage(long accountId, long messageId, String to, String cc, String bcc, String subject, String body, List<MailFile> mailFiles) throws PortalException {
        try {
            Mailbox mailbox = MailboxFactoryUtil.getMailbox((long)this._user.getUserId(), (long)accountId, (String)this._passwordRetriever.getPassword(accountId));
            com.liferay.mail.reader.model.Message message = mailbox.saveDraft(accountId, messageId, to, cc, bcc, subject, body, mailFiles);
            mailbox.sendMessage(accountId, message.getMessageId());
            return this.createJSONResult("success", "sent-successfully");
        }
        catch (FileSizeException fse) {
            return this.createJSONResult("failure", "attachment-is-too-large");
        }
        catch (MailException me) {
            if (me.getType() == 13) {
                return this.createJSONResult("failure", "please-specify-at-least-one-recipient");
            }
            if (me.getType() == 14) {
                return this.createJSONResult("failure", "please-make-sure-the-following-address-is-properly-formatted", HtmlUtil.escape((String)me.getValue()));
            }
            _log.error((Object)me, (Throwable)me);
            return this.createJSONResult("failure", "unable-to-send-message");
        }
    }

    public JSONObject storePassword(long accountId, String password) throws PortalException {
        Account account = AccountLocalServiceUtil.getAccount((long)accountId);
        if (!account.isSavePassword()) {
            Mailbox mailbox = MailboxFactoryUtil.getMailbox((long)this._user.getUserId(), (long)accountId, (String)this._passwordRetriever.getPassword(accountId));
            try {
                mailbox.validateAccount(account.getIncomingHostName(), account.getIncomingPort(), account.getIncomingSecure(), account.getOutgoingHostName(), account.getOutgoingPort(), account.getOutgoingSecure(), account.getLogin(), password);
                this._passwordRetriever.setPassword(accountId, password);
                return this.createJSONResult("success", "logged-in-successfully");
            }
            catch (MailException me) {
                return this.createJSONResult("failure", "incorrect-password");
            }
        }
        return this.createJSONResult("success", "password-has-already-been-saved");
    }

    public void synchronizeAccount(long accountId) throws PortalException {
        this.synchronize(accountId, 0L, 0L, 0, 0);
    }

    public void synchronizeFolder(long folderId) throws PortalException {
        Folder folder = FolderLocalServiceUtil.getFolder((long)folderId);
        this.synchronize(folder.getAccountId(), folderId, 0L, 0, 0);
    }

    public void synchronizeMessage(long messageId) throws PortalException {
        com.liferay.mail.reader.model.Message message = MessageLocalServiceUtil.getMessage((long)messageId);
        this.synchronize(message.getAccountId(), 0L, messageId, 0, 0);
    }

    public void synchronizePage(long folderId, int pageNumber, int messagesPerPage) throws PortalException {
        Folder folder = FolderLocalServiceUtil.getFolder((long)folderId);
        this.synchronize(folder.getAccountId(), folderId, 0L, pageNumber, messagesPerPage);
    }

    public JSONObject updateAccount(long accountId, String personalName, String password, boolean savePassword, String signature, boolean useSignature, String folderPrefix, boolean defaultSender) throws PortalException {
        return this.updateAccount(accountId, personalName, password, savePassword, signature, useSignature, folderPrefix, defaultSender, 0L, 0L, 0L, 0L);
    }

    public JSONObject updateAccount(long accountId, String personalName, String password, boolean savePassword, String signature, boolean useSignature, String folderPrefix, boolean defaultSender, long inboxFolderId, long draftFolderId, long sentFolderId, long trashFolderId) throws PortalException {
        try {
            if (savePassword) {
                this._passwordRetriever.removePassword(accountId);
            }
            if (Validator.isNull((String)password)) {
                String oldPassword = this._passwordRetriever.getPassword(accountId);
                if (Validator.isNull((String)oldPassword)) {
                    throw new MailException("no password");
                }
                password = oldPassword;
            }
            Mailbox mailbox = MailboxFactoryUtil.getMailbox((long)this._user.getUserId(), (long)accountId, (String)password);
            mailbox.updateAccount(accountId, personalName, password, savePassword, signature, useSignature, folderPrefix, defaultSender);
            if (inboxFolderId > 0L) {
                mailbox.updateFolders(inboxFolderId, draftFolderId, sentFolderId, trashFolderId);
            } else {
                mailbox.updateFolders();
            }
            return this.createJSONResult("success", "account-has-been-updated");
        }
        catch (MailException me) {
            if (me.getType() == 13) {
                return this.createJSONResult("failure", "please-specify-at-least-one-recipient");
            }
            if (me.getType() == 14) {
                return this.createJSONResult("failure", "please-make-sure-the-following-address-is-properly-formatted", me.getValue());
            }
            _log.error((Object)me, (Throwable)me);
            return this.createJSONResult("failure", "unable-to-update-account");
        }
    }

    protected JSONObject createJSONResult(String status, String message) {
        return this.createJSONResult(status, message, null);
    }

    protected JSONObject createJSONResult(String status, String message, String value) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        ResourceBundle resourceBundle = this._portletConfig.getResourceBundle(this._user.getLocale());
        jsonObject.put("message", LanguageUtil.get((ResourceBundle)resourceBundle, (String)message));
        jsonObject.put("status", status);
        if (Validator.isNotNull((String)value)) {
            jsonObject.put("value", value);
        }
        return jsonObject;
    }

    protected void synchronize(long accountId, long folderId, long messageId, int pageNumber, int messagesPerPage) throws PortalException {
        String password = this._passwordRetriever.getPassword(accountId);
        if (Validator.isNull((String)password)) {
            return;
        }
        Message message = new Message();
        message.put("command", (Object)"synchronize");
        message.put("userId", (Object)this._user.getUserId());
        message.put("accountId", (Object)accountId);
        message.put("password", (Object)password);
        message.put("folderId", (Object)folderId);
        message.put("messageId", (Object)messageId);
        message.put("pageNumber", (Object)pageNumber);
        message.put("messagesPerPage", (Object)messagesPerPage);
        MessageBusUtil.sendMessage((String)"liferay/mail_synchronizer", (Message)message);
    }
}

