/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.mail.reader.exception.NoSuchFolderException;
import com.liferay.mail.reader.model.Folder;
import com.liferay.mail.reader.model.impl.FolderImpl;
import com.liferay.mail.reader.model.impl.FolderModelImpl;
import com.liferay.mail.reader.service.persistence.FolderPersistence;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ProviderType
public class FolderPersistenceImpl
extends BasePersistenceImpl<Folder>
implements FolderPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = FolderImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(FolderModelImpl.ENTITY_CACHE_ENABLED, FolderModelImpl.FINDER_CACHE_ENABLED, FolderImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(FolderModelImpl.ENTITY_CACHE_ENABLED, FolderModelImpl.FINDER_CACHE_ENABLED, FolderImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(FolderModelImpl.ENTITY_CACHE_ENABLED, FolderModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_ACCOUNTID = new FinderPath(FolderModelImpl.ENTITY_CACHE_ENABLED, FolderModelImpl.FINDER_CACHE_ENABLED, FolderImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByAccountId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ACCOUNTID = new FinderPath(FolderModelImpl.ENTITY_CACHE_ENABLED, FolderModelImpl.FINDER_CACHE_ENABLED, FolderImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByAccountId", new String[]{Long.class.getName()}, 3L);
    public static final FinderPath FINDER_PATH_COUNT_BY_ACCOUNTID = new FinderPath(FolderModelImpl.ENTITY_CACHE_ENABLED, FolderModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByAccountId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_ACCOUNTID_ACCOUNTID_2 = "folder.accountId = ?";
    public static final FinderPath FINDER_PATH_FETCH_BY_A_F = new FinderPath(FolderModelImpl.ENTITY_CACHE_ENABLED, FolderModelImpl.FINDER_CACHE_ENABLED, FolderImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByA_F", new String[]{Long.class.getName(), String.class.getName()}, 3L);
    public static final FinderPath FINDER_PATH_COUNT_BY_A_F = new FinderPath(FolderModelImpl.ENTITY_CACHE_ENABLED, FolderModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByA_F", new String[]{Long.class.getName(), String.class.getName()});
    private static final String _FINDER_COLUMN_A_F_ACCOUNTID_2 = "folder.accountId = ? AND ";
    private static final String _FINDER_COLUMN_A_F_FULLNAME_1 = "folder.fullName IS NULL";
    private static final String _FINDER_COLUMN_A_F_FULLNAME_2 = "folder.fullName = ?";
    private static final String _FINDER_COLUMN_A_F_FULLNAME_3 = "(folder.fullName IS NULL OR folder.fullName = '')";
    @ServiceReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_FOLDER = "SELECT folder FROM Folder folder";
    private static final String _SQL_SELECT_FOLDER_WHERE_PKS_IN = "SELECT folder FROM Folder folder WHERE folderId IN (";
    private static final String _SQL_SELECT_FOLDER_WHERE = "SELECT folder FROM Folder folder WHERE ";
    private static final String _SQL_COUNT_FOLDER = "SELECT COUNT(folder) FROM Folder folder";
    private static final String _SQL_COUNT_FOLDER_WHERE = "SELECT COUNT(folder) FROM Folder folder WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "folder.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Folder exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Folder exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(FolderPersistenceImpl.class);

    public List<Folder> findByAccountId(long accountId) {
        return this.findByAccountId(accountId, -1, -1, null);
    }

    public List<Folder> findByAccountId(long accountId, int start, int end) {
        return this.findByAccountId(accountId, start, end, null);
    }

    public List<Folder> findByAccountId(long accountId, int start, int end, OrderByComparator<Folder> orderByComparator) {
        return this.findByAccountId(accountId, start, end, orderByComparator, true);
    }

    public List<Folder> findByAccountId(long accountId, int start, int end, OrderByComparator<Folder> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ACCOUNTID;
            finderArgs = new Object[]{accountId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_ACCOUNTID;
            finderArgs = new Object[]{accountId, start, end, orderByComparator};
        }
        List<Folder> list = null;
        if (retrieveFromCache && (list = (List<Folder>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Folder folder : list) {
                if (accountId == folder.getAccountId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_FOLDER_WHERE);
            query.append(_FINDER_COLUMN_ACCOUNTID_ACCOUNTID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY folder.fullName ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(accountId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Folder findByAccountId_First(long accountId, OrderByComparator<Folder> orderByComparator) throws NoSuchFolderException {
        Folder folder = this.fetchByAccountId_First(accountId, orderByComparator);
        if (folder != null) {
            return folder;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("accountId=");
        msg.append(accountId);
        msg.append("}");
        throw new NoSuchFolderException(msg.toString());
    }

    public Folder fetchByAccountId_First(long accountId, OrderByComparator<Folder> orderByComparator) {
        List<Folder> list = this.findByAccountId(accountId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Folder findByAccountId_Last(long accountId, OrderByComparator<Folder> orderByComparator) throws NoSuchFolderException {
        Folder folder = this.fetchByAccountId_Last(accountId, orderByComparator);
        if (folder != null) {
            return folder;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("accountId=");
        msg.append(accountId);
        msg.append("}");
        throw new NoSuchFolderException(msg.toString());
    }

    public Folder fetchByAccountId_Last(long accountId, OrderByComparator<Folder> orderByComparator) {
        int count = this.countByAccountId(accountId);
        if (count == 0) {
            return null;
        }
        List<Folder> list = this.findByAccountId(accountId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Folder[] findByAccountId_PrevAndNext(long folderId, long accountId, OrderByComparator<Folder> orderByComparator) throws NoSuchFolderException {
        Folder folder = this.findByPrimaryKey(folderId);
        Session session = null;
        try {
            session = this.openSession();
            Folder[] array = new FolderImpl[]{this.getByAccountId_PrevAndNext(session, folder, accountId, orderByComparator, true), folder, this.getByAccountId_PrevAndNext(session, folder, accountId, orderByComparator, false)};
            Folder[] folderArray = array;
            return folderArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Folder getByAccountId_PrevAndNext(Session session, Folder folder, long accountId, OrderByComparator<Folder> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_FOLDER_WHERE);
        query.append(_FINDER_COLUMN_ACCOUNTID_ACCOUNTID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY folder.fullName ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(accountId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)folder)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Folder)list.get(1);
        }
        return null;
    }

    public void removeByAccountId(long accountId) {
        for (Folder folder : this.findByAccountId(accountId, -1, -1, null)) {
            this.remove((BaseModel)folder);
        }
    }

    public int countByAccountId(long accountId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_ACCOUNTID;
        Object[] finderArgs = new Object[]{accountId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_FOLDER_WHERE);
            query.append(_FINDER_COLUMN_ACCOUNTID_ACCOUNTID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(accountId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Folder findByA_F(long accountId, String fullName) throws NoSuchFolderException {
        Folder folder = this.fetchByA_F(accountId, fullName);
        if (folder == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("accountId=");
            msg.append(accountId);
            msg.append(", fullName=");
            msg.append(fullName);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchFolderException(msg.toString());
        }
        return folder;
    }

    public Folder fetchByA_F(long accountId, String fullName) {
        return this.fetchByA_F(accountId, fullName, true);
    }

    public Folder fetchByA_F(long accountId, String fullName, boolean retrieveFromCache) {
        Folder folder;
        Object[] finderArgs = new Object[]{accountId, fullName};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_A_F, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof Folder && (accountId != (folder = (Folder)result).getAccountId() || !Objects.equals(fullName, folder.getFullName()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_FOLDER_WHERE);
            query.append(_FINDER_COLUMN_A_F_ACCOUNTID_2);
            boolean bindFullName = false;
            if (fullName == null) {
                query.append(_FINDER_COLUMN_A_F_FULLNAME_1);
            } else if (fullName.equals("")) {
                query.append(_FINDER_COLUMN_A_F_FULLNAME_3);
            } else {
                bindFullName = true;
                query.append(_FINDER_COLUMN_A_F_FULLNAME_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(accountId);
                if (bindFullName) {
                    qPos.add(fullName);
                }
                if ((list = q.list()).isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_A_F, finderArgs, (Object)list);
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("FolderPersistenceImpl.fetchByA_F(long, String, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    Folder folder2 = (Folder)list.get(0);
                    result = folder2;
                    this.cacheResult(folder2);
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_A_F, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Folder)result;
    }

    public Folder removeByA_F(long accountId, String fullName) throws NoSuchFolderException {
        Folder folder = this.findByA_F(accountId, fullName);
        return (Folder)this.remove((BaseModel)folder);
    }

    public int countByA_F(long accountId, String fullName) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_A_F;
        Object[] finderArgs = new Object[]{accountId, fullName};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_FOLDER_WHERE);
            query.append(_FINDER_COLUMN_A_F_ACCOUNTID_2);
            boolean bindFullName = false;
            if (fullName == null) {
                query.append(_FINDER_COLUMN_A_F_FULLNAME_1);
            } else if (fullName.equals("")) {
                query.append(_FINDER_COLUMN_A_F_FULLNAME_3);
            } else {
                bindFullName = true;
                query.append(_FINDER_COLUMN_A_F_FULLNAME_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(accountId);
                if (bindFullName) {
                    qPos.add(fullName);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public FolderPersistenceImpl() {
        this.setModelClass(Folder.class);
    }

    public void cacheResult(Folder folder) {
        this.entityCache.putResult(FolderModelImpl.ENTITY_CACHE_ENABLED, FolderImpl.class, (Serializable)Long.valueOf(folder.getPrimaryKey()), (Serializable)folder);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_A_F, new Object[]{folder.getAccountId(), folder.getFullName()}, (Object)folder);
        folder.resetOriginalValues();
    }

    public void cacheResult(List<Folder> folders) {
        for (Folder folder : folders) {
            if (this.entityCache.getResult(FolderModelImpl.ENTITY_CACHE_ENABLED, FolderImpl.class, (Serializable)Long.valueOf(folder.getPrimaryKey())) == null) {
                this.cacheResult(folder);
                continue;
            }
            folder.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(FolderImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(Folder folder) {
        this.entityCache.removeResult(FolderModelImpl.ENTITY_CACHE_ENABLED, FolderImpl.class, (Serializable)Long.valueOf(folder.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((FolderModelImpl)folder, true);
    }

    public void clearCache(List<Folder> folders) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Folder folder : folders) {
            this.entityCache.removeResult(FolderModelImpl.ENTITY_CACHE_ENABLED, FolderImpl.class, (Serializable)Long.valueOf(folder.getPrimaryKey()));
            this.clearUniqueFindersCache((FolderModelImpl)folder, true);
        }
    }

    protected void cacheUniqueFindersCache(FolderModelImpl folderModelImpl) {
        Object[] args = new Object[]{folderModelImpl.getAccountId(), folderModelImpl.getFullName()};
        this.finderCache.putResult(FINDER_PATH_COUNT_BY_A_F, args, (Object)1L, false);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_A_F, args, (Object)folderModelImpl, false);
    }

    protected void clearUniqueFindersCache(FolderModelImpl folderModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{folderModelImpl.getAccountId(), folderModelImpl.getFullName()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_A_F, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_A_F, args);
        }
        if ((folderModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_A_F.getColumnBitmask()) != 0L) {
            args = new Object[]{folderModelImpl.getOriginalAccountId(), folderModelImpl.getOriginalFullName()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_A_F, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_A_F, args);
        }
    }

    public Folder create(long folderId) {
        FolderImpl folder = new FolderImpl();
        folder.setNew(true);
        folder.setPrimaryKey(folderId);
        folder.setCompanyId(this.companyProvider.getCompanyId());
        return folder;
    }

    public Folder remove(long folderId) throws NoSuchFolderException {
        return this.remove(Long.valueOf(folderId));
    }

    public Folder remove(Serializable primaryKey) throws NoSuchFolderException {
        Session session = null;
        try {
            session = this.openSession();
            Folder folder = (Folder)session.get(FolderImpl.class, primaryKey);
            if (folder == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchFolderException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Folder folder2 = (Folder)this.remove((BaseModel)folder);
            return folder2;
        }
        catch (NoSuchFolderException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Folder removeImpl(Folder folder) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)folder)) {
                folder = (Folder)session.get(FolderImpl.class, folder.getPrimaryKeyObj());
            }
            if (folder != null) {
                session.delete((Object)folder);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (folder != null) {
            this.clearCache(folder);
        }
        return folder;
    }

    public Folder updateImpl(Folder folder) {
        boolean isNew = folder.isNew();
        if (!(folder instanceof FolderModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(folder.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)folder);
                throw new IllegalArgumentException("Implement ModelWrapper in folder proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Folder implementation " + folder.getClass());
        }
        FolderModelImpl folderModelImpl = (FolderModelImpl)folder;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && folder.getCreateDate() == null) {
            if (serviceContext == null) {
                folder.setCreateDate(now);
            } else {
                folder.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!folderModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                folder.setModifiedDate(now);
            } else {
                folder.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (folder.isNew()) {
                session.save((Object)folder);
                folder.setNew(false);
            } else {
                folder = (Folder)session.merge((Object)folder);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!FolderModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{folderModelImpl.getAccountId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_ACCOUNTID, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ACCOUNTID, args);
            this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL, FINDER_ARGS_EMPTY);
        } else if ((folderModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ACCOUNTID.getColumnBitmask()) != 0L) {
            Object[] args = new Object[]{folderModelImpl.getOriginalAccountId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_ACCOUNTID, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ACCOUNTID, args);
            args = new Object[]{folderModelImpl.getAccountId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_ACCOUNTID, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ACCOUNTID, args);
        }
        this.entityCache.putResult(FolderModelImpl.ENTITY_CACHE_ENABLED, FolderImpl.class, (Serializable)Long.valueOf(folder.getPrimaryKey()), (Serializable)folder, false);
        this.clearUniqueFindersCache(folderModelImpl, false);
        this.cacheUniqueFindersCache(folderModelImpl);
        folder.resetOriginalValues();
        return folder;
    }

    public Folder findByPrimaryKey(Serializable primaryKey) throws NoSuchFolderException {
        Folder folder = this.fetchByPrimaryKey(primaryKey);
        if (folder == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchFolderException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return folder;
    }

    public Folder findByPrimaryKey(long folderId) throws NoSuchFolderException {
        return this.findByPrimaryKey(Long.valueOf(folderId));
    }

    public Folder fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(FolderModelImpl.ENTITY_CACHE_ENABLED, FolderImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        Folder folder = (Folder)serializable;
        if (folder == null) {
            Session session = null;
            try {
                session = this.openSession();
                folder = (Folder)session.get(FolderImpl.class, primaryKey);
                if (folder != null) {
                    this.cacheResult(folder);
                } else {
                    this.entityCache.putResult(FolderModelImpl.ENTITY_CACHE_ENABLED, FolderImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception e) {
                this.entityCache.removeResult(FolderModelImpl.ENTITY_CACHE_ENABLED, FolderImpl.class, primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return folder;
    }

    public Folder fetchByPrimaryKey(long folderId) {
        return this.fetchByPrimaryKey(Long.valueOf(folderId));
    }

    public Map<Serializable, Folder> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, Folder> map = new HashMap<Serializable, Folder>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            Folder folder = this.fetchByPrimaryKey(primaryKey);
            if (folder != null) {
                map.put(primaryKey, folder);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(FolderModelImpl.ENTITY_CACHE_ENABLED, FolderImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (Folder)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_FOLDER_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            query.append(((Long)serializable).longValue());
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String string = query.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(string);
            for (Folder folder : q.list()) {
                map.put(folder.getPrimaryKeyObj(), folder);
                this.cacheResult(folder);
                uncachedPrimaryKeys.remove(folder.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(FolderModelImpl.ENTITY_CACHE_ENABLED, FolderImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception e) {
            try {
                throw this.processException(e);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<Folder> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Folder> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Folder> findAll(int start, int end, OrderByComparator<Folder> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<Folder> findAll(int start, int end, OrderByComparator<Folder> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_FOLDER);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_FOLDER;
                if (pagination) {
                    sql = sql.concat(" ORDER BY folder.fullName ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Folder folder : this.findAll()) {
            this.remove((BaseModel)folder);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_FOLDER);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return FolderModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
    }

    public void destroy() {
        this.entityCache.removeCache(FolderImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

